/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture;

import android.opengl.GLES20;
import com.gensee.texture.GLLog;
import com.gensee.utils.GenseeLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class GSGLProgram {
    private static final String TAG = "GSGLProgram";
    private ByteBuffer _vertice_buffer;
    private ByteBuffer _coord_buffer;
    private boolean isProgBuilt;
    private int _program;
    private int _positionHandle;
    private int _coordHandle;
    private int _yhandle;
    private int _uhandle;
    private int _vhandle;
    private int _video_width;
    private int _video_height;
    private int _ytid;
    private int _utid;
    private int _vtid;
    private int _tIindex;
    private int _tIIindex;
    private int _tIIIindex;
    private static float[] squareVertices = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private static float[] coordVertices = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private static final String VERTEX_SHADER = "attribute vec4 vPosition;\nattribute vec2 a_texCoord;\nvarying vec2 tc;\nvoid main() {\ngl_Position = vPosition;\ntc = a_texCoord;\n}\n";
    private static final String FRAGMENT_SHADER = "precision mediump float;\nuniform sampler2D tex_y;\nuniform sampler2D tex_u;\nuniform sampler2D tex_v;\nvarying vec2 tc;\nvoid main() {\nvec4 c = vec4((texture2D(tex_y, tc).r - 16./255.) * 1.164);\nvec4 U = vec4(texture2D(tex_u, tc).r - 128./255.);\nvec4 V = vec4(texture2D(tex_v, tc).r - 128./255.);\nc += V * vec4(1.596, -0.813, 0, 0);\nc += U * vec4(0, -0.392, 2.017, 0);\nc.a = 1.0;\ngl_FragColor = c;\n}\n";

    public GSGLProgram(int i) {
    }

    public boolean isProgramBuilt() {
        return this.isProgBuilt;
    }

    public void buildProgram() {
        this.createBuffers(squareVertices, coordVertices);
        if (this._program <= 0) {
            this._program = this.createProgram(VERTEX_SHADER, FRAGMENT_SHADER);
        }
        GenseeLog.d(TAG, "buildProgram _program = " + this._program);
        this._positionHandle = GLES20.glGetAttribLocation((int)this._program, (String)"vPosition");
        GenseeLog.d(TAG, "buildProgram _positionHandle = " + this._positionHandle);
        this.checkGlError("glGetAttribLocation vPosition");
        if (this._positionHandle == -1) {
            throw new RuntimeException("Could not get attribute location for vPosition");
        }
        this._coordHandle = GLES20.glGetAttribLocation((int)this._program, (String)"a_texCoord");
        GLLog.LOGD("_coordHandle = " + this._coordHandle);
        this.checkGlError("glGetAttribLocation a_texCoord");
        if (this._coordHandle == -1) {
            throw new RuntimeException("Could not get attribute location for a_texCoord");
        }
        this._yhandle = GLES20.glGetUniformLocation((int)this._program, (String)"tex_y");
        GLES20.glUniform1i((int)this._yhandle, (int)0);
        GLLog.LOGD("_yhandle = " + this._yhandle);
        this.checkGlError("glGetUniformLocation tex_y");
        if (this._yhandle == -1) {
            throw new RuntimeException("Could not get uniform location for tex_y");
        }
        this._uhandle = GLES20.glGetUniformLocation((int)this._program, (String)"tex_u");
        GLES20.glUniform1i((int)this._uhandle, (int)1);
        GLLog.LOGD("_uhandle = " + this._uhandle);
        this.checkGlError("glGetUniformLocation tex_u");
        if (this._uhandle == -1) {
            throw new RuntimeException("Could not get uniform location for tex_u");
        }
        this._vhandle = GLES20.glGetUniformLocation((int)this._program, (String)"tex_v");
        GLLog.LOGD("_vhandle = " + this._vhandle);
        GLES20.glUniform1i((int)this._vhandle, (int)2);
        this.checkGlError("glGetUniformLocation tex_v");
        if (this._vhandle == -1) {
            throw new RuntimeException("Could not get uniform location for tex_v");
        }
        this.isProgBuilt = true;
    }

    public void buildTextures(Buffer y, Buffer u, Buffer v, int width, int height) {
        int[] textures;
        boolean videoSizeChanged;
        boolean bl = videoSizeChanged = width != this._video_width || height != this._video_height;
        if (videoSizeChanged) {
            this._video_width = width;
            this._video_height = height;
            GLLog.LOGD("buildTextures videoSizeChanged: w=" + this._video_width + " h=" + this._video_height);
        }
        if (this._ytid < 0 || videoSizeChanged) {
            if (this._ytid >= 0) {
                GLLog.LOGD("glDeleteTextures Y");
                GLES20.glDeleteTextures((int)1, (int[])new int[]{this._ytid}, (int)0);
                this.checkGlError("glDeleteTextures");
            }
            textures = new int[1];
            GLES20.glGenTextures((int)1, (int[])textures, (int)0);
            this.checkGlError("glGenTextures");
            this._ytid = textures[0];
            GLLog.LOGD("glGenTextures Y = " + this._ytid);
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this._ytid);
        this.checkGlError("glBindTexture");
        GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)this._video_width, (int)this._video_height, (int)0, (int)6409, (int)5121, (Buffer)y);
        this.checkGlError("glTexImage2D");
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        if (this._utid < 0 || videoSizeChanged) {
            if (this._utid >= 0) {
                GenseeLog.d("glDeleteTextures U");
                GLES20.glDeleteTextures((int)1, (int[])new int[]{this._utid}, (int)0);
                this.checkGlError("glDeleteTextures");
            }
            textures = new int[1];
            GLES20.glGenTextures((int)1, (int[])textures, (int)0);
            this.checkGlError("glGenTextures");
            this._utid = textures[0];
            GLLog.LOGD("glGenTextures U = " + this._utid);
        }
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)this._utid);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)(this._video_width / 2), (int)(this._video_height / 2), (int)0, (int)6409, (int)5121, (Buffer)u);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        if (this._vtid < 0 || videoSizeChanged) {
            if (this._vtid >= 0) {
                GLLog.LOGD("glDeleteTextures V");
                GLES20.glDeleteTextures((int)1, (int[])new int[]{this._vtid}, (int)0);
                this.checkGlError("glDeleteTextures");
            }
            textures = new int[1];
            GLES20.glGenTextures((int)1, (int[])textures, (int)0);
            this.checkGlError("glGenTextures");
            this._vtid = textures[0];
            GLLog.LOGD("glGenTextures V = " + this._vtid);
        }
        GLES20.glActiveTexture((int)33986);
        GLES20.glBindTexture((int)3553, (int)this._vtid);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)(this._video_width / 2), (int)(this._video_height / 2), (int)0, (int)6409, (int)5121, (Buffer)v);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
    }

    public void drawFrame(Buffer y, Buffer u, Buffer v, int width, int height) {
        GLES20.glUseProgram((int)this._program);
        this.checkGlError("glUseProgram");
        GLES20.glVertexAttribPointer((int)this._positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this._vertice_buffer);
        this.checkGlError("glVertexAttribPointer mPositionHandle");
        GLES20.glEnableVertexAttribArray((int)this._positionHandle);
        GLES20.glVertexAttribPointer((int)this._coordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this._coord_buffer);
        this.checkGlError("glVertexAttribPointer maTextureHandle");
        GLES20.glEnableVertexAttribArray((int)this._coordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this._ytid);
        GLES20.glUniform1i((int)this._yhandle, (int)0);
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)this._utid);
        GLES20.glUniform1i((int)this._uhandle, (int)1);
        GLES20.glActiveTexture((int)33986);
        GLES20.glBindTexture((int)3553, (int)this._vtid);
        GLES20.glUniform1i((int)this._vhandle, (int)2);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glFinish();
        GLES20.glDisableVertexAttribArray((int)this._positionHandle);
        GLES20.glDisableVertexAttribArray((int)this._coordHandle);
    }

    public int createProgram(String vertexSource, String fragmentSource) {
        int vertexShader = this.loadShader(35633, vertexSource);
        int pixelShader = this.loadShader(35632, fragmentSource);
        GLLog.LOGD("vertexShader = " + vertexShader);
        GLLog.LOGD("pixelShader = " + pixelShader);
        int program = GLES20.glCreateProgram();
        if (program != 0) {
            GLES20.glAttachShader((int)program, (int)vertexShader);
            this.checkGlError("glAttachShader");
            GLES20.glAttachShader((int)program, (int)pixelShader);
            this.checkGlError("glAttachShader");
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                GLLog.LOGE("Could not link program: ", null);
                GLLog.LOGE(GLES20.glGetProgramInfoLog((int)program), null);
                GLES20.glDeleteProgram((int)program);
                program = 0;
            }
        }
        return program;
    }

    private int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        if (shader != 0) {
            GLES20.glShaderSource((int)shader, (String)source);
            GLES20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
            if (compiled[0] == 0) {
                GLLog.LOGE("Could not compile shader " + shaderType + ":", null);
                GLLog.LOGE(GLES20.glGetShaderInfoLog((int)shader), null);
                GLES20.glDeleteShader((int)shader);
                shader = 0;
            }
        }
        return shader;
    }

    private void createBuffers(float[] vert, float[] coord) {
        this._vertice_buffer = ByteBuffer.allocateDirect(vert.length * 4);
        this._vertice_buffer.order(ByteOrder.nativeOrder());
        this._vertice_buffer.asFloatBuffer().put(vert);
        ((Buffer)this._vertice_buffer).position(0);
        if (this._coord_buffer == null) {
            this._coord_buffer = ByteBuffer.allocateDirect(coord.length * 4);
            this._coord_buffer.order(ByteOrder.nativeOrder());
            this._coord_buffer.asFloatBuffer().put(coord);
            ((Buffer)this._coord_buffer).position(0);
        }
    }

    private void checkGlError(String op) {
        int error;
        while ((error = GLES20.glGetError()) != 0) {
            GLLog.e(TAG, "checkGlError " + op + ": glError " + error);
        }
    }
}

