/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.TextureView;
import com.gensee.texture.GSGLESTVThread;
import com.gensee.texture.IGSGLESRenderer;
import com.gensee.utils.GenseeLog;

public class GSGLESTextureView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private static final String TAG = "GSGLESTextureView";
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    private GSGLESTVThread mGLThread;
    private IGSGLESRenderer mRenderer;
    private int mRendererMode = 1;
    private Bitmap mBitmap;

    public GSGLESTextureView(Context context) {
        super(context);
        this.init(context);
    }

    public GSGLESTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public void setRenderer(IGSGLESRenderer renderer) {
        this.mRenderer = renderer;
    }

    public void setRenderMode(int mode) {
        this.mRendererMode = mode;
    }

    public void requestRender() {
        if (this.mRendererMode != 0) {
            return;
        }
        if (this.mGLThread != null) {
            this.mGLThread.requestRender();
        }
    }

    private void init(Context context) {
        this.setSurfaceTextureListener(this);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        if (this.mGLThread == null) {
            this.mGLThread = new GSGLESTVThread(surface, this.mRenderer);
            this.mGLThread.setRenderMode(this.mRendererMode);
            this.mGLThread.start();
        } else {
            this.mGLThread.updateTexture(surface);
        }
        this.sizeChaned(surface, width, height);
    }

    private void sizeChaned(SurfaceTexture surface, int width, int height) {
        if (this.mGLThread != null) {
            this.mGLThread.onSurfaceChanged(width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        GenseeLog.d(TAG, "onSurfaceTextureDestroyed surface " + surface);
        if (this.mGLThread != null) {
            this.mGLThread.onDestroy();
            this.mGLThread = null;
        }
        return true;
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        GenseeLog.d(TAG, "onSurfaceTextureSizeChanged surface " + surface + " width = " + width + " height = " + height);
        this.sizeChaned(surface, width, height);
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public void onResume() {
        if (this.mGLThread != null) {
            this.mGLThread.onResume();
        }
    }

    public void onPause() {
        if (this.mGLThread != null) {
            this.mGLThread.onPause();
        }
    }

    public void onDestroy() {
        if (this.mGLThread != null) {
            this.mGLThread.onDestroy();
        }
    }

    public void addToPending(Runnable r) {
        if (this.mGLThread != null) {
            this.mGLThread.addToPending(r);
        }
    }

    protected void drawFrame() {
        if (this.mGLThread != null) {
            this.mGLThread.drawFrame();
        }
    }

    protected void drawFrame(Bitmap bitmap) {
        this.mBitmap = bitmap;
        if (this.mGLThread != null) {
            this.mGLThread.drawFrame(bitmap);
        }
    }
}

