/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.GLUtils;
import com.gensee.texture.GSPendingThreadAider;
import com.gensee.texture.IGSGLESRenderer;
import com.gensee.utils.GenseeLog;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

class GSGLESTVThread
extends Thread {
    private static final String TAG = "GSGLESTVThread";
    private SurfaceTexture mSurfaceTexture;
    private EGL10 mEgl;
    private EGLDisplay mEglDisplay = EGL10.EGL_NO_DISPLAY;
    private EGLSurface mEglSurface = EGL10.EGL_NO_SURFACE;
    private EGLContext mEglContext = EGL10.EGL_NO_CONTEXT;
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    private IGSGLESRenderer mRenderer;
    private GSPendingThreadAider mPendingThreadAider = new GSPendingThreadAider();
    private boolean mNeedRenderring = true;
    private Object LOCK = new Object();
    private boolean mIsPaused = false;
    private int mRendererMode = 1;

    public GSGLESTVThread(SurfaceTexture surface, IGSGLESRenderer renderer) {
        this.mSurfaceTexture = surface;
        this.mRenderer = renderer;
    }

    @Override
    public void run() {
        GenseeLog.d(TAG, "run enter " + this);
        this.initGLESContext();
        this.mRenderer.onSurfaceCreated();
        while (this.mNeedRenderring) {
            this.mPendingThreadAider.runPendings();
            if (!this.mIsPaused) continue;
            this.pauseWhile();
        }
        this.destoryGLESContext();
        GenseeLog.d(TAG, "run end " + this);
    }

    public void drawFrame() {
        this.mRenderer.onDrawFrame();
        if (this.mEgl != null) {
            this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface);
        }
    }

    public void drawFrame(Bitmap bitmap) {
        this.mRenderer.onDrawFrame(bitmap);
        this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface);
    }

    private void initGLESContext() {
        GenseeLog.d(TAG, "initGLESContext enter");
        this.mEgl = (EGL10)EGLContext.getEGL();
        this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetdisplay failed : " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
        }
        int[] version = new int[2];
        if (!this.mEgl.eglInitialize(this.mEglDisplay, version)) {
            throw new RuntimeException("eglInitialize failed : " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
        }
        int[] configAttribs = new int[]{12320, 32, 12321, 8, 12322, 8, 12323, 8, 12324, 8, 12352, 4, 12339, 4, 12344};
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        if (!this.mEgl.eglChooseConfig(this.mEglDisplay, configAttribs, configs, 1, numConfigs)) {
            throw new RuntimeException("eglChooseConfig failed : " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
        }
        int[] contextAttribs = new int[]{12440, 2, 12344};
        this.mEglContext = this.mEgl.eglCreateContext(this.mEglDisplay, configs[0], EGL10.EGL_NO_CONTEXT, contextAttribs);
        this.mEglSurface = this.mEgl.eglCreateWindowSurface(this.mEglDisplay, configs[0], (Object)this.mSurfaceTexture, null);
        if (this.mEglSurface == EGL10.EGL_NO_SURFACE || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
            this.destoryGLESContext();
        } else if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
            throw new RuntimeException("eglMakeCurrent failed : " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseWhile() {
        Object object = this.LOCK;
        synchronized (object) {
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void destoryGLESContext() {
        GenseeLog.d(TAG, "destoryGLESContext");
        this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        if (this.mEglSurface != EGL10.EGL_NO_SURFACE) {
            this.mEgl.eglDestroySurface(this.mEglDisplay, this.mEglSurface);
        }
        this.mEglSurface = EGL10.EGL_NO_SURFACE;
        if (this.mEglContext != EGL10.EGL_NO_CONTEXT) {
            this.mEgl.eglDestroyContext(this.mEglDisplay, this.mEglContext);
        }
        this.mEglContext = EGL10.EGL_NO_CONTEXT;
        if (this.mEglDisplay != null) {
            this.mEgl.eglTerminate(this.mEglDisplay);
        }
    }

    public void onPause() {
        this.mIsPaused = true;
    }

    public void onResume() {
        this.mIsPaused = false;
        this.requestRender();
    }

    public void onSurfaceChanged(final int width, final int height) {
        this.mPendingThreadAider.addToPending(new Runnable(){

            @Override
            public void run() {
                GSGLESTVThread.this.mRenderer.onSurfaceChanged(width, height);
                GSGLESTVThread.this.drawFrame();
            }
        });
        this.requestRender();
    }

    public void setRenderMode(int mode) {
        this.mRendererMode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRender() {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notifyAll();
        }
    }

    public void updateTexture(final SurfaceTexture surfaceTexture) {
        this.addToPending(new Runnable(){

            @Override
            public void run() {
                GSGLESTVThread.this.destoryGLESContext();
                GSGLESTVThread.this.mSurfaceTexture = surfaceTexture;
                GSGLESTVThread.this.initGLESContext();
                GSGLESTVThread.this.mRenderer.onSurfaceCreated();
            }
        });
    }

    public void addToPending(Runnable r) {
        this.mPendingThreadAider.addToPending(r);
    }

    public void onDestroy() {
        this.mNeedRenderring = false;
        this.requestRender();
    }
}

