/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.media;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.gensee.media.ISurfaceHolder;
import com.gensee.media.IVideoIndication;
import com.gensee.media.VideoData;
import com.gensee.utils.GenseeLog;
import java.lang.ref.SoftReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ViSoftRender
implements IVideoIndication {
    private static final String TAG = "ViSoftRender";
    private IVideoIndication.RenderMode renderMode = IVideoIndication.RenderMode.RM_ADPT_XY;
    private static final Object LOCK = new Object();
    private ISurfaceHolder mHolder;
    private int mWidth;
    private int mHeight;
    private int defColor = -16777216;
    private SoftReference<Bitmap> defBitmapRef = null;
    private boolean isFillXY = false;
    private byte[] data = null;
    private boolean isDestroyed;
    private SoftReference<Bitmap> videoBit;
    private BitmapDrawable drawable;
    private int mH264Width;
    private int mH264Height;
    private int mVideoWidth;
    private int mVideoHeight;
    private Matrix m;

    public ViSoftRender(ISurfaceHolder holder) {
        this.mHolder = holder;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getVideoWidth() {
        return this.mH264Width;
    }

    public int getVideoHeight() {
        return this.mH264Height;
    }

    public IVideoIndication.RenderMode getRenderMode() {
        return this.renderMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderMode(IVideoIndication.RenderMode renderMode) {
        GenseeLog.d(TAG, "setRenderMode renderMode = " + (Object)((Object)renderMode));
        this.renderMode = renderMode;
        if (!this.isDestroyed || this.videoBit == null || this.drawable == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            this.updateVideoMatrix();
            this.drawFram(this.mHolder, this.m, (Drawable)this.drawable, false);
        }
    }

    @Override
    public void onReceiveFrame(byte[] data, int width, int height) {
        this.data = data;
        this.onReceiveData(data, width, height, width, height);
    }

    @Override
    public void onReceiveFrame(VideoData data) {
        this.data = data.getData();
        this.onReceiveData(data.getData(), data.getWidth(), data.getHeight(), data.getDisplayW(), data.getDisplayH());
    }

    public void surfaceChanged(int width, int height) {
        if (width != this.mWidth || height != this.mHeight) {
            this.mWidth = width;
            this.mHeight = height;
            if (this.mH264Width > 0 && this.mH264Height > 0) {
                this.updateVideoMatrix();
            }
        } else {
            GenseeLog.d(TAG, "surfaceChanged size unchanged");
        }
        if (this.data != null) {
            this.onReceiveData(this.data, this.mH264Width, this.mH264Height, this.mVideoWidth, this.mVideoHeight);
        } else {
            Bitmap b = null;
            if (this.defBitmapRef != null) {
                b = this.defBitmapRef.get();
            }
            if (b != null) {
                this.renderDrawble(this.mHolder, b);
            }
        }
    }

    public void surfaceCreated() {
        this.isDestroyed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceDestroyed() {
        Object object = LOCK;
        synchronized (object) {
            this.isDestroyed = true;
            if (this.videoBit != null) {
                Bitmap b = this.videoBit.get();
                if (b != null) {
                    b.recycle();
                }
                this.videoBit.clear();
                this.videoBit = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onReceiveData(byte[] data, int h264Width, int h264Height, int displayW, int displayH) {
        if (h264Width == 0 || h264Height == 0 || null == data || data.length <= 0) {
            GenseeLog.w("ViSoftRender -> onReceiveData h264Width = " + h264Width + " h264Height = " + h264Height);
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            if (!this.isDestroyed) {
                Bitmap b;
                if (this.mH264Width != h264Width || this.mH264Height != h264Height || this.videoBit == null) {
                    b = null;
                    if (null != this.videoBit) {
                        b = this.videoBit.get();
                    }
                    this.videoBit = null;
                    try {
                        this.videoBit = new SoftReference<Bitmap>(Bitmap.createBitmap((int)h264Width, (int)h264Height, (Bitmap.Config)Bitmap.Config.RGB_565));
                    }
                    catch (OutOfMemoryError e) {
                        GenseeLog.w("OutOfMemoryError video err!");
                    }
                    if (b != null) {
                        b.recycle();
                    }
                    if (this.videoBit == null) {
                        System.gc();
                        return;
                    }
                    this.mH264Width = h264Width;
                    this.mH264Height = h264Height;
                    this.drawable = new BitmapDrawable(this.mHolder.getContext().getApplicationContext().getResources(), this.videoBit.get());
                    this.drawable.setBounds(0, 0, this.mH264Width, this.mH264Height);
                    this.updateVideoMatrix();
                }
                if (displayW != this.mVideoWidth || displayH != this.mVideoHeight) {
                    this.mVideoWidth = displayW;
                    this.mVideoHeight = displayH;
                    this.updateVideoMatrix();
                }
                try {
                    b = this.videoBit.get();
                    if (b != null) {
                        b.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(data));
                    } else {
                        GenseeLog.w(TAG, "b is null");
                    }
                }
                catch (RuntimeException e) {
                    GenseeLog.w(TAG, e);
                    return;
                }
                catch (Exception e) {
                    GenseeLog.w(TAG, e);
                    return;
                }
                this.drawFram(this.mHolder, this.m, (Drawable)this.drawable, false);
            }
        }
    }

    protected void drawFram(ISurfaceHolder holder, Matrix m, Drawable d, boolean isOnlyBg) {
        if (holder == null) {
            return;
        }
        Canvas canvas = null;
        if (!this.isDestroyed) {
            canvas = holder.lockCanvas();
        }
        if (canvas != null) {
            canvas.save();
            canvas.drawColor(this.defColor);
            if (!isOnlyBg && d != null) {
                try {
                    canvas.concat(m);
                    d.draw(canvas);
                }
                catch (Exception e) {
                    GenseeLog.w(TAG, e.getMessage());
                }
            }
            canvas.restore();
            if (!this.isDestroyed) {
                try {
                    holder.unlockCanvasAndPost(canvas);
                }
                catch (Exception e) {
                    GenseeLog.w(TAG, e.getMessage());
                }
            }
        }
    }

    @Override
    public void renderDefault() {
        if (null != this.data) {
            this.data = null;
        }
        this.drawFram(this.mHolder, null, null, true);
    }

    public void setDefColor(int defColor) {
        this.defColor = defColor;
    }

    private void updateVideoMatrix() {
        if (this.m == null) {
            this.m = new Matrix();
        }
        this.m.reset();
        boolean mRotate = false;
        if (!mRotate) {
            float px = 1.0f * (float)this.mWidth / (float)this.mVideoWidth;
            float py = 1.0f * (float)this.mHeight / (float)this.mVideoHeight;
            float opx = 1.0f * (float)this.mVideoWidth / (float)this.mH264Width;
            float opy = 1.0f * (float)this.mVideoHeight / (float)this.mH264Height;
            switch (this.renderMode) {
                case RM_ADPT_XY: {
                    float[] values = new float[9];
                    if (px < py) {
                        this.m.postScale(px * opx, px * opy);
                        this.m.getValues(values);
                        values[5] = ((float)this.mHeight - (float)this.mVideoHeight * px) / 2.0f;
                    } else {
                        this.m.postScale(py * opx, py * opy);
                        this.m.getValues(values);
                        values[2] = ((float)this.mWidth - (float)this.mVideoWidth * py) / 2.0f;
                    }
                    this.m.setValues(values);
                    GenseeLog.d(TAG, "updateVideoMatrix RM_ADPT_XY values = " + values);
                    break;
                }
                case RM_FILL_XY: {
                    this.m.postScale(px * opx, py * opy);
                    break;
                }
                case RM_CENTER: {
                    if (!(px > 0.0f) || !(py > 0.0f)) break;
                    this.m.postScale(opx, opy);
                    this.m.postTranslate((float)(this.mWidth - this.mVideoWidth) / 2.0f, (float)(this.mHeight - this.mVideoHeight) / 2.0f);
                    break;
                }
                case RM_FILL_CENTER_CROP: {
                    float[] fvalues = new float[9];
                    if (px > py) {
                        this.m.postScale(px * opx, px * opy);
                        this.m.getValues(fvalues);
                        fvalues[5] = ((float)this.mHeight - (float)this.mVideoHeight * px) / 2.0f;
                    } else {
                        this.m.postScale(py * opx, py * opy);
                        this.m.getValues(fvalues);
                        fvalues[2] = ((float)this.mWidth - (float)this.mVideoWidth * py) / 2.0f;
                    }
                    this.m.setValues(fvalues);
                    GenseeLog.d(TAG, "updateVideoMatrix RM_FILL_CENTER_CROP values = " + fvalues);
                    break;
                }
            }
        } else {
            this.m.postScale(1.0f * (float)this.mHeight / (float)this.mH264Width, 1.0f * (float)this.mWidth / (float)this.mH264Height);
            this.m.postRotate(90.0f, 0.0f, 0.0f);
            this.m.postTranslate((float)this.mWidth, 0.0f);
        }
    }

    public void renderDrawble(Bitmap defBitmap, boolean isFillXY) {
        if (defBitmap == null) {
            return;
        }
        this.isFillXY = isFillXY;
        if (this.defBitmapRef != null) {
            Bitmap b = this.defBitmapRef.get();
            if (b != null) {
                b.recycle();
            }
            this.defBitmapRef.clear();
        }
        this.defBitmapRef = new SoftReference<Bitmap>(defBitmap);
        if (!this.isDestroyed) {
            this.renderDrawble(this.mHolder, defBitmap);
        }
    }

    private void renderDrawble(ISurfaceHolder holder, Bitmap defBitmap) {
        Matrix m = new Matrix();
        float bw = defBitmap.getWidth();
        float bh = defBitmap.getHeight();
        float sx = 1.0f;
        float sy = 1.0f;
        if (this.isFillXY) {
            sx = (float)this.mWidth / bw;
            sy = (float)this.mHeight / bh;
            m.postScale(sx, sy);
        } else if (bw > (float)this.mWidth || bh > (float)this.mHeight) {
            sx = (float)this.mWidth / bw;
            sy = (float)this.mHeight / bh;
            if (sx > sy) {
                m.postScale(sy, sy);
                m.postTranslate(0.0f, ((float)this.mWidth - bw * sy) / 2.0f);
            } else {
                m.postTranslate(((float)this.mHeight - bh * sx) / 2.0f, 0.0f);
                m.postScale(sx, sx);
            }
        } else {
            m.postTranslate(((float)this.mWidth - bw) / 2.0f, ((float)this.mHeight - bh) / 2.0f);
        }
        BitmapDrawable d = new BitmapDrawable(this.mHolder.getContext().getResources(), defBitmap);
        d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
        this.drawFram(holder, m, (Drawable)d, false);
    }
}

