/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.media;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import com.gensee.media.ColorFormatConversion;
import com.gensee.media.MediaConfiger;
import com.gensee.media.VideoData;
import com.gensee.utils.GenseeLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ViEncoder
extends Thread {
    private static final String TYPE = "video/avc";
    private static final String TAG = "ViEncoder";
    private static final int TIMEOUT_USEC = 12000;
    private Object lock = new Object();
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private List<VideoData> datas = new ArrayList<VideoData>();
    private MediaCodec encoder;
    private int width;
    private int height;
    private int mBitRate;
    private int mFps = 25;
    private byte[] i420bytes;
    private static int colorFmt = 0;
    private ColorFormatConversion mFmtConversion;
    private long frameIndex = 0L;
    private FileOutputStream stream = null;
    private FileOutputStream streamYuv1 = null;
    private FileOutputStream streamYuv2 = null;

    public void forceKeyFrame() {
        GenseeLog.d(TAG, "forceKeyFrame width = " + this.width + " height = " + this.height);
        VideoData data = new VideoData(4);
        data.width = this.width;
        data.height = this.height;
        data.bitRate = this.mBitRate;
        data.fps = this.mFps;
        this.addTask(data, true);
    }

    public ViEncoder() {
        super(TAG);
    }

    public void encodeFrame(byte[] buf, int width, int height, int length, int flag) {
        if (width != this.width || height != this.height) {
            GenseeLog.d("ViEncoder encodeFrame width = " + width + " heigth = " + height + " buflength = " + buf.length);
            this.update(width, height);
        }
        if (this.isRunning.get()) {
            this.addTask(new VideoData(buf, width, height, 0L, length, 3, flag), false);
        }
    }

    public void update(int width, int height) {
        VideoData data = new VideoData(1);
        data.width = width;
        data.height = height;
        data.bitRate = this.mBitRate;
        data.fps = this.mFps;
        this.addTask(data, false);
    }

    public void setBitRate(int mBitRate) {
        if (mBitRate > 0 && this.mBitRate != mBitRate) {
            if (this.isRunning.get()) {
                VideoData data = new VideoData(1);
                data.width = this.width;
                data.height = this.height;
                data.bitRate = mBitRate;
                data.fps = this.mFps;
                this.addTask(data, false);
            } else {
                this.mBitRate = mBitRate;
            }
        }
    }

    public void setFps(int mFps) {
        if (mFps > 0 && this.mFps != mFps) {
            if (this.isRunning.get()) {
                VideoData data = new VideoData(1);
                data.width = this.width;
                data.height = this.height;
                data.fps = mFps;
                data.bitRate = this.mBitRate;
                this.addTask(data, false);
            } else {
                this.mFps = mFps;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            this.close();
            this.close1();
            this.close2();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isRunning.set(false);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(VideoData data, boolean top) {
        Object object = this.lock;
        synchronized (object) {
            int size = this.datas.size();
            if (top) {
                this.datas.add(0, data);
            } else if (size < 3) {
                this.datas.add(data);
            }
            this.lock.notifyAll();
        }
    }

    public static boolean isEnable(int width, int height) {
        ViEncoder e = new ViEncoder();
        boolean enable = e.init(width, height, 25, ViEncoder.getBitRate(width, height));
        e.releaseEncoder();
        return enable;
    }

    public boolean init(int width, int height, int fps, int bitRate) {
        if (width == this.width && height == this.height && fps == this.mFps && bitRate == this.mBitRate && this.encoder != null) {
            return true;
        }
        this.mFps = fps;
        this.mBitRate = bitRate;
        this.width = width;
        this.height = height;
        if (colorFmt != 0) {
            this.releaseEncoder();
            this.encoder = ViEncoder.createEncoder(width, height, colorFmt, this.mFps, this.mBitRate);
        } else {
            MediaCodec codec = null;
            codec = ViEncoder.createEncoder(width, height, 21, this.mFps, this.mBitRate);
            if (codec == null) {
                codec = ViEncoder.createEncoder(width, height, 19, this.mFps, this.mBitRate);
                if (codec != null) {
                    colorFmt = 19;
                    this.encoder = codec;
                }
            } else {
                colorFmt = 21;
                this.encoder = codec;
            }
        }
        this.mFmtConversion = ColorFormatConversion.createForColorFormat(colorFmt);
        GenseeLog.d("ViEncoder init width = " + width + " heigth = " + height + " encoder = " + this.encoder + " colorFmt = " + colorFmt + " fps = " + this.mFps + " bitRate = " + this.mBitRate);
        return this.encoder != null;
    }

    private static MediaCodec createEncoder(int width, int height, int colorFmt, int fps, int bitRate) {
        MediaCodec mediaCodec = null;
        try {
            MediaConfiger configer = MediaConfiger.getConfiger();
            int iframeInterval = configer.getIframeInterval();
            iframeInterval = iframeInterval == 0 ? 5 : iframeInterval;
            GenseeLog.d(TAG, "createEncoder frameRate = " + fps + " bitRate = " + bitRate + " iframeInterval = " + iframeInterval);
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)TYPE, (int)width, (int)height);
            mediaFormat.setInteger("bitrate", bitRate);
            mediaFormat.setInteger("frame-rate", fps);
            mediaFormat.setInteger("color-format", colorFmt);
            mediaFormat.setInteger("i-frame-interval", iframeInterval);
            mediaCodec = MediaCodec.createEncoderByType((String)TYPE);
            mediaCodec.configure(mediaFormat, null, null, 1);
            mediaCodec.start();
            return mediaCodec;
        }
        catch (Throwable e) {
            if (mediaCodec != null) {
                mediaCodec.release();
            }
            e.printStackTrace();
            GenseeLog.w(TAG, "createEncoder fail by " + e.getMessage());
            return null;
        }
    }

    public static int getBitRate(int width, int height) {
        int abs;
        int bitrate = 150;
        int minAbs = 0;
        if (width < height) {
            minAbs = width;
            width = height;
            height = minAbs;
            minAbs = 0;
        }
        if ((minAbs = (abs = ViEncoder.distance(width, height, 320, 240))) > abs) {
            minAbs = abs;
            bitrate = 150;
        }
        if (minAbs > (abs = ViEncoder.distance(width, height, 352, 288))) {
            minAbs = abs;
            bitrate = 200;
        }
        if (minAbs > (abs = ViEncoder.distance(width, height, 640, 480))) {
            minAbs = abs;
            bitrate = 250;
        }
        if (minAbs > (abs = ViEncoder.distance(width, height, 720, 576))) {
            minAbs = abs;
            bitrate = 260;
        }
        if (minAbs > (abs = ViEncoder.distance(width, height, 960, 540))) {
            minAbs = abs;
            bitrate = 270;
        }
        if (minAbs > (abs = ViEncoder.distance(width, height, 1280, 720))) {
            minAbs = abs;
            bitrate = 280;
        }
        if (minAbs > (abs = ViEncoder.distance(width, height, 1920, 1080))) {
            minAbs = abs;
            bitrate = 350;
        }
        bitrate = bitrate * 3 - 50;
        GenseeLog.d(TAG, "getBitRate = " + bitrate * 1000 + " width = " + width + " height = " + height);
        return bitrate * 1000;
    }

    private static int distance(int x1, int y1, int x2, int y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isRunning.set(true);
        while (this.isRunning.get()) {
            VideoData data = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.datas.size() > 0) {
                    data = this.datas.remove(0);
                } else if (this.isRunning.get()) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    break;
                }
            }
            if (data == null) continue;
            switch (data.cmd) {
                case 3: {
                    if (data.width != this.width || data.height != this.height) break;
                    try {
                        byte[] tmp = this.mFmtConversion.convert(data.data, this.width, this.height);
                        this.encode(tmp, 0, this.width * this.height * 3 / 2, data.flag);
                    }
                    catch (Exception e) {
                        GenseeLog.w("ViEncoder encode exception");
                        e.printStackTrace();
                    }
                    break;
                }
                case 4: {
                    this.forceKey();
                    break;
                }
                case 1: {
                    int bitRate;
                    if (data.width <= 0 || data.height <= 0) break;
                    GenseeLog.d("ViEncoder run VideoData.CMD_ENCODER_CREATE threadid = " + Thread.currentThread().getId());
                    int fps = data.fps <= 0 ? this.mFps : data.fps;
                    int n = bitRate = data.bitRate <= 0 ? this.mBitRate : data.bitRate;
                    if (bitRate > 0) {
                        int maxBitRate;
                        int minBitRate = 150000;
                        if (bitRate < minBitRate) {
                            bitRate = minBitRate;
                        }
                        if (bitRate > (maxBitRate = ViEncoder.getBitRate(1920, 1080))) {
                            bitRate = maxBitRate;
                        }
                    } else {
                        bitRate = ViEncoder.getBitRate(data.width, data.height);
                    }
                    this.isRunning.set(this.init(data.width, data.height, fps, bitRate));
                    break;
                }
                case 2: {
                    this.releaseEncoder();
                    break;
                }
            }
        }
        this.releaseEncoder();
    }

    private void releaseEncoder() {
        try {
            if (this.encoder != null) {
                this.encoder.stop();
                this.encoder.release();
            }
        }
        catch (Exception e) {
            GenseeLog.w("ViEncoder releaseEncoder exception");
            e.printStackTrace();
        }
        this.frameIndex = 0L;
        this.encoder = null;
    }

    private long computePresentationTime(long frameIndex) {
        return 132L + frameIndex * 1000000L / 15L;
    }

    public void encode(byte[] buf, int offset, int length, int flag) throws IllegalStateException {
        MediaCodec codec = this.encoder;
        if (codec == null) {
            GenseeLog.w(TAG, "encode codec = null");
            return;
        }
        ByteBuffer[] inputBuffers = codec.getInputBuffers();
        ByteBuffer[] outputBuffers = codec.getOutputBuffers();
        int inputBufferIndex = codec.dequeueInputBuffer(-1L);
        if (inputBufferIndex >= 0) {
            ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
            ((Buffer)inputBuffer).clear();
            inputBuffer.put(buf, offset, length);
            codec.queueInputBuffer(inputBufferIndex, 0, length, this.computePresentationTime(this.frameIndex), flag);
            ++this.frameIndex;
        }
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        int outputBufferIndex = codec.dequeueOutputBuffer(bufferInfo, 12000L);
        while (outputBufferIndex >= 0) {
            ByteBuffer outputBuffer = outputBuffers[outputBufferIndex];
            byte[] tmp = new byte[bufferInfo.size];
            outputBuffer.get(tmp);
            this.onEncode(tmp, 0, bufferInfo.size, bufferInfo.flags, this.width, this.height);
            codec.releaseOutputBuffer(outputBufferIndex, false);
            outputBufferIndex = codec.dequeueOutputBuffer(bufferInfo, 12000L);
        }
    }

    public void onEncode(byte[] outputBuffer, int i, int size, int flags, int width, int height) {
    }

    private void initFile() throws IOException {
        File f = new File("/sdcard/android-h264.h264");
        if (!f.exists()) {
            f.createNewFile();
        }
        this.stream = new FileOutputStream(f);
    }

    private void close() throws IOException {
        if (this.stream != null) {
            this.stream.flush();
            this.stream.close();
        }
    }

    private void initFile1() throws IOException {
        File f = new File("/sdcard/android-yuv1.yuv");
        if (!f.exists()) {
            f.createNewFile();
        }
        this.streamYuv1 = new FileOutputStream(f);
    }

    private void close1() throws IOException {
        if (this.streamYuv1 != null) {
            this.streamYuv1.flush();
            this.streamYuv1.close();
        }
    }

    private void initFile2() throws IOException {
        File f = new File("/sdcard/android-yuv2.yuv");
        if (!f.exists()) {
            f.createNewFile();
        }
        this.streamYuv2 = new FileOutputStream(f);
    }

    private void close2() throws IOException {
        if (this.streamYuv2 != null) {
            this.streamYuv2.flush();
            this.streamYuv2.close();
        }
    }

    private void forceKey() {
        if (Build.VERSION.SDK_INT >= 19 && this.encoder != null) {
            try {
                Bundle b = new Bundle();
                b.putInt("request-sync", 1);
                GenseeLog.d(TAG, "forceKey PARAMETER_KEY_REQUEST_SYNC_FRAME");
                this.encoder.setParameters(b);
            }
            catch (Exception e) {
                GenseeLog.w(TAG, "forceKey is exception :" + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

