/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.view.Surface;
import com.gensee.media.OnVideoDecodeListener;
import com.gensee.media.VideoData;
import com.gensee.utils.GenseeLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=16)
public class ViDecoder
extends Thread {
    private static final String TYPE = "video/avc";
    public static final int AVC_HEADER_FLAG1 = 7;
    public static final int AVC_HEADER_FLAG2 = 8;
    public static final int I_FRAME = 5;
    public static final int P_FRAME = 1;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private ArrayList<VideoData> datas = new ArrayList();
    private Surface surface;
    private Map<Long, Decoder> decoderMap = new HashMap<Long, Decoder>();
    private int colorFomat = 0;
    private static final String TAG = "ViDecoder";

    public ViDecoder() {
        super(TAG);
        this.isRunning.set(true);
        this.start();
    }

    public void setSurface(Surface surface) {
        this.surface = surface;
    }

    public void setDecodeListener(long userId, OnVideoDecodeListener l) {
        Decoder d = this.getDecoder(userId);
        if (d != null) {
            d.setOnVideoDecodeListener(l);
        }
    }

    public void decode(long userId, byte[] data, int width, int height, int flag) {
        this.decodeData(new VideoData(data, width, height, userId, data.length, 0, flag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decodeCache(List<VideoData> caches) {
        if (this.isRunning.get()) {
            ArrayList<VideoData> arrayList = this.datas;
            synchronized (arrayList) {
                this.datas.addAll(caches);
                this.datas.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decodeData(VideoData data) {
        if (this.isRunning.get()) {
            ArrayList<VideoData> arrayList = this.datas;
            synchronized (arrayList) {
                this.datas.add(data);
                this.datas.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.isRunning.set(false);
        ArrayList<VideoData> arrayList = this.datas;
        synchronized (arrayList) {
            this.datas.clear();
            this.datas.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isRunning.get()) {
            VideoData data = null;
            ArrayList<VideoData> arrayList = this.datas;
            synchronized (arrayList) {
                int n = this.datas.size();
                if (n > 2) {
                    GenseeLog.d(TAG, "datassize = " + n);
                }
                if (n > 0) {
                    data = this.datas.remove(0);
                    this.datas.notifyAll();
                } else if (this.isRunning.get()) {
                    try {
                        this.datas.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    break;
                }
            }
            if (data == null) continue;
            this.decode(data);
        }
        Set<Map.Entry<Long, Decoder>> sets = this.decoderMap.entrySet();
        for (Map.Entry entry : sets) {
            Decoder d = (Decoder)entry.getValue();
            if (d == null) continue;
            d.release();
        }
        this.decoderMap.clear();
    }

    private int decode(VideoData vData) {
        Decoder d = this.getDecoder(vData.getUserId());
        d.decode(vData);
        return 0;
    }

    private Decoder getDecoder(long userId) {
        Decoder decoder = this.decoderMap.get(userId);
        if (decoder == null) {
            decoder = new Decoder();
            this.decoderMap.put(userId, decoder);
        }
        return decoder;
    }

    private class Decoder {
        private static final String TAG = "Decoder";
        private MediaCodec decoder;
        private OnVideoDecodeListener listener;
        private boolean bNeedAvc = false;
        private int mWidth;
        private int mHeight;
        final int SPSPPSLENGTH = 37;
        byte[] preSpsPPs = new byte[37];
        byte[] newData = new byte[37];
        int rec = 0;
        int intput = 0;
        int output = 0;

        private Decoder() {
        }

        public MediaCodec createDecoder(int width, int height, Surface surface, int colorFormat) {
            MediaCodec decoder = null;
            try {
                decoder = MediaCodec.createDecoderByType((String)ViDecoder.TYPE);
                MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)ViDecoder.TYPE, (int)(width == 0 ? 320 : width), (int)(height == 0 ? 240 : height));
                decoder.configure(mediaFormat, surface, null, 0);
                decoder.start();
                this.decoder = decoder;
                this.mWidth = width;
                this.mHeight = height;
            }
            catch (Exception e) {
                GenseeLog.w(TAG, "createDecoder " + e.toString() + decoder);
                e.printStackTrace();
            }
            return decoder;
        }

        boolean isEqalSpsPps(byte[] newData) {
            GenseeLog.i(TAG, "isEqalSpsPps preSpsPPs length=" + this.preSpsPPs.length + ",newData length=" + newData.length);
            boolean bEqaul = true;
            if (null != newData && null != this.preSpsPPs && newData.length == this.preSpsPPs.length) {
                for (int i = 0; i < 37; ++i) {
                    if (this.preSpsPPs[i] == newData[i]) continue;
                    GenseeLog.d(TAG, "i=" + i + ",preSpsPPs[i]=" + this.preSpsPPs[i] + ",newData[i]=" + newData[i]);
                    bEqaul = false;
                    break;
                }
            } else {
                bEqaul = false;
            }
            if (!bEqaul) {
                System.arraycopy(newData, 0, this.preSpsPPs, 0, newData.length);
            }
            return bEqaul;
        }

        public int decode(VideoData vData) {
            int i;
            int frameType = vData.data[4] & 0x1F;
            if (this.decoder == null) {
                this.createDecoder(vData.width, vData.height, ViDecoder.this.surface, 19);
                this.bNeedAvc = true;
            } else if (this.mWidth != vData.width || this.mHeight != vData.height) {
                if (vData.data.length >= 37) {
                    for (i = 0; i < 37; ++i) {
                        this.newData[i] = vData.data[i];
                    }
                }
                if (!this.isEqalSpsPps(this.newData)) {
                    GenseeLog.i(TAG, " decode avc changed");
                    this.release();
                    this.createDecoder(vData.width, vData.height, ViDecoder.this.surface, 19);
                    this.bNeedAvc = false;
                }
            }
            if (this.bNeedAvc) {
                GenseeLog.d(TAG, "Decoder decode bNeedAvc frameType = " + frameType + " length = " + vData.data.length + " vData= " + vData.toString());
                if (frameType != 7 && frameType != 8) {
                    return 0;
                }
                if (vData.data.length >= 37) {
                    for (i = 0; i < 37; ++i) {
                        this.preSpsPPs[i] = vData.data[i];
                    }
                }
                this.bNeedAvc = false;
            }
            int result = 0;
            try {
                result = this.decode(vData.data, 0, vData.length, vData.flag);
            }
            catch (Exception e) {
                GenseeLog.w(TAG, "decode " + e.toString() + this.decoder);
                e.printStackTrace();
            }
            return result;
        }

        public int decode(byte[] buf, int offset, int length, int flag) throws IllegalStateException {
            if (this.decoder == null) {
                return 0;
            }
            ++this.rec;
            int inputBufferIndex = this.decoder.dequeueInputBuffer(-1L);
            if (inputBufferIndex >= 0) {
                ByteBuffer inputBuffer;
                ++this.intput;
                if (Build.VERSION.SDK_INT < 21) {
                    ByteBuffer[] inputBuffers = this.decoder.getInputBuffers();
                    inputBuffer = inputBuffers[inputBufferIndex];
                } else {
                    inputBuffer = this.decoder.getInputBuffer(inputBufferIndex);
                }
                if (inputBuffer != null) {
                    ((Buffer)inputBuffer).clear();
                    inputBuffer.put(buf, offset, length);
                }
                this.decoder.queueInputBuffer(inputBufferIndex, offset, length, 0L, 0);
            }
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int outputBufferIndex = this.decoder.dequeueOutputBuffer(bufferInfo, 10L);
            while (outputBufferIndex >= 0) {
                int h;
                int w;
                boolean bAutoDraw;
                ++this.output;
                boolean bl = bAutoDraw = null != ViDecoder.this.surface;
                if (this.mWidth == 0 || this.mHeight == 0) {
                    MediaFormat mediaFormat = this.decoder.getOutputFormat();
                    w = mediaFormat.getInteger("width");
                    h = mediaFormat.getInteger("height");
                } else {
                    w = this.mWidth;
                    h = this.mHeight;
                }
                if (!bAutoDraw) {
                    ByteBuffer outputBuffer = this.decoder.getOutputBuffer(outputBufferIndex);
                    int size = w * h * 3 / 2;
                    if (outputBuffer != null) {
                        try {
                            byte[] buff = new byte[size];
                            if (ViDecoder.this.colorFomat == 21) {
                                outputBuffer.get(buff, 0, w * h);
                                for (int i = 0; i < w * h / 4; ++i) {
                                    outputBuffer.get(buff, w * h + i, 1);
                                    outputBuffer.get(buff, w * h * 5 / 4 + i, 1);
                                }
                            } else if (ViDecoder.this.colorFomat == 19) {
                                outputBuffer.get(buff, 0, w * h);
                                outputBuffer.get(buff, w * h * 5 / 4, w * h / 4);
                                outputBuffer.get(buff, w * h, w * h / 4);
                            } else {
                                outputBuffer.get(buff, 0, size);
                            }
                            OnVideoDecodeListener l = this.listener;
                            if (l != null) {
                                l.onDecodeData(buff, w, h);
                            }
                        }
                        catch (Exception e) {
                            GenseeLog.w(TAG, "decode  size = " + size + " bufferInfo = " + bufferInfo.flags + " pos = " + outputBuffer.position());
                        }
                    } else {
                        GenseeLog.w(TAG, "decode  outputBuffer is null");
                    }
                } else {
                    OnVideoDecodeListener l = this.listener;
                    if (l != null) {
                        l.onDecodeData(null, w, h);
                    }
                }
                this.decoder.releaseOutputBuffer(outputBufferIndex, bAutoDraw);
                outputBufferIndex = this.decoder.dequeueOutputBuffer(bufferInfo, 10L);
            }
            return 0;
        }

        public void release() {
            if (this.decoder != null) {
                try {
                    this.decoder.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.decoder.release();
                this.decoder = null;
            }
        }

        public void setOnVideoDecodeListener(OnVideoDecodeListener l) {
            this.listener = l;
        }
    }
}

