/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.media;

import com.gensee.common.GenseeConfig;
import com.gensee.utils.GenseeLog;

public class ColorFormatConversion {
    private static final String TAG = "ColorFormatConversion";
    protected byte[] tmpData = null;

    public static ColorFormatConversion createConversion() {
        return new ColorFormatConversion();
    }

    public byte[] convert(byte[] data, int width, int height) {
        return this.onConvert(data, width, height);
    }

    protected void createTmpBuffer(int len) {
        if (this.tmpData == null || this.tmpData.length != len) {
            this.tmpData = new byte[len];
        }
    }

    protected byte[] onConvert(byte[] data, int width, int height) {
        return data;
    }

    public static ColorFormatConversion createForColorFormat(int format) {
        ColorFormatConversion colorFormatConversion = null;
        switch (format) {
            case 21: {
                colorFormatConversion = GenseeConfig.isTV ? ColorFormatConversion.createNV12ToSemiI420() : ColorFormatConversion.createYV12ToSemiI420();
                break;
            }
            case 19: {
                colorFormatConversion = GenseeConfig.isTV ? ColorFormatConversion.createNV21ToI420() : ColorFormatConversion.createYV12ToI420();
                break;
            }
            default: {
                colorFormatConversion = ColorFormatConversion.createConversion();
            }
        }
        return colorFormatConversion;
    }

    public static ColorFormatConversion createYV12ToI420() {
        GenseeLog.d(TAG, "createYV12ToI420");
        return new ColorFormatConversion(){

            @Override
            public byte[] convert(byte[] yv12, int width, int height) {
                int tmpWxH = width * height;
                this.createTmpBuffer(tmpWxH * 3 / 2);
                System.arraycopy(yv12, 0, this.tmpData, 0, tmpWxH);
                System.arraycopy(yv12, tmpWxH + tmpWxH / 4, this.tmpData, tmpWxH, tmpWxH / 4);
                System.arraycopy(yv12, tmpWxH, this.tmpData, tmpWxH + tmpWxH / 4, tmpWxH / 4);
                return this.tmpData;
            }
        };
    }

    public static ColorFormatConversion createYV12ToSemiI420() {
        GenseeLog.d(TAG, "createYV12ToSemiI420");
        return new ColorFormatConversion(){

            @Override
            protected byte[] onConvert(byte[] yv12, int width, int height) {
                int tmpWxH = width * height;
                this.createTmpBuffer(tmpWxH * 3 / 2);
                System.arraycopy(yv12, 0, this.tmpData, 0, tmpWxH);
                for (int i = 0; i < tmpWxH / 4; ++i) {
                    this.tmpData[tmpWxH + 2 * i + 1] = yv12[tmpWxH + i];
                    this.tmpData[tmpWxH + 2 * i] = yv12[tmpWxH + tmpWxH / 4 + i];
                }
                return this.tmpData;
            }
        };
    }

    public static ColorFormatConversion createNV12ToSemiI420() {
        GenseeLog.d(TAG, "createNV12ToSemiI420");
        return new ColorFormatConversion(){

            @Override
            protected byte[] onConvert(byte[] nv12, int width, int height) {
                int tmpWxH = width * height;
                int len = tmpWxH * 3 / 2;
                this.createTmpBuffer(len);
                System.arraycopy(nv12, 0, this.tmpData, 0, tmpWxH);
                for (int i = tmpWxH; i < len; i += 2) {
                    this.tmpData[i] = nv12[i + 1];
                    this.tmpData[i + 1] = nv12[i];
                }
                return this.tmpData;
            }
        };
    }

    public static ColorFormatConversion createNV12ToYV12() {
        GenseeLog.d(TAG, "createNV12ToYV12");
        return new ColorFormatConversion(){

            @Override
            protected byte[] onConvert(byte[] nv12, int width, int height) {
                int tmpWxH = width * height;
                int len = tmpWxH * 3 / 2;
                int uLen = tmpWxH / 4;
                this.createTmpBuffer(len);
                System.arraycopy(nv12, 0, this.tmpData, 0, tmpWxH);
                for (int i = 0; i < uLen; ++i) {
                    this.tmpData[tmpWxH + i] = nv12[tmpWxH + 2 * i];
                    this.tmpData[tmpWxH + uLen + i] = nv12[tmpWxH + 2 * i + 1];
                }
                return this.tmpData;
            }
        };
    }

    public static ColorFormatConversion createNV21ToYV12() {
        GenseeLog.d(TAG, "createNV21ToYV12");
        return new ColorFormatConversion(){

            @Override
            protected byte[] onConvert(byte[] nv12, int width, int height) {
                int tmpWxH = width * height;
                int len = tmpWxH * 3 / 2;
                int uLen = tmpWxH / 4;
                this.createTmpBuffer(len);
                System.arraycopy(nv12, 0, this.tmpData, 0, tmpWxH);
                for (int i = 0; i < uLen; ++i) {
                    this.tmpData[tmpWxH + i] = nv12[tmpWxH + 2 * i + 1];
                    this.tmpData[tmpWxH + uLen + i] = nv12[tmpWxH + 2 * i];
                }
                return this.tmpData;
            }
        };
    }

    public static ColorFormatConversion createNV12ToI420() {
        GenseeLog.d(TAG, "createNV12ToI420");
        return new ColorFormatConversion(){

            @Override
            protected byte[] onConvert(byte[] nv12, int width, int height) {
                int tmpWxH = width * height;
                int len = tmpWxH * 3 / 2;
                int uLen = tmpWxH / 4;
                this.createTmpBuffer(len);
                System.arraycopy(nv12, 0, this.tmpData, 0, tmpWxH);
                for (int i = 0; i < uLen; ++i) {
                    this.tmpData[tmpWxH + i] = nv12[tmpWxH + 2 * i + 1];
                    this.tmpData[tmpWxH + uLen + i] = nv12[tmpWxH + 2 * i];
                }
                return this.tmpData;
            }
        };
    }

    public static ColorFormatConversion createNV21ToI420() {
        GenseeLog.d(TAG, "createNV21ToI420");
        return new ColorFormatConversion(){

            @Override
            protected byte[] onConvert(byte[] nv21, int width, int height) {
                int tmpWxH = width * height;
                int len = tmpWxH * 3 / 2;
                int uLen = tmpWxH / 4;
                this.createTmpBuffer(len);
                System.arraycopy(nv21, 0, this.tmpData, 0, tmpWxH);
                for (int i = 0; i < uLen; ++i) {
                    this.tmpData[tmpWxH + i] = nv21[tmpWxH + 2 * i];
                    this.tmpData[tmpWxH + uLen + i] = nv21[tmpWxH + 2 * i + 1];
                }
                return this.tmpData;
            }
        };
    }

    public static ColorFormatConversion createI420ToSemiI420() {
        return new ColorFormatConversion(){

            @Override
            protected byte[] onConvert(byte[] i420, int width, int height) {
                int tmpWxH = width * height;
                this.createTmpBuffer(tmpWxH * 3 / 2);
                System.arraycopy(i420, 0, this.tmpData, 0, tmpWxH);
                for (int i = 0; i < tmpWxH / 4; ++i) {
                    this.tmpData[tmpWxH + 2 * i] = i420[tmpWxH + i];
                    this.tmpData[tmpWxH + 2 * i + 1] = i420[tmpWxH + tmpWxH / 4 + i];
                }
                return this.tmpData;
            }
        };
    }
}

