/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.media;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.ThreadPool;

public class BlueToother {
    public static final int SDK_FLAG_PLAYER = 1;
    public static final int SDK_FLAG_RT = 2;
    private int sdkFlags = 0;
    private static final String TAG = "BlueToother";
    private AudioManager manager = null;
    private int state = 0;
    private boolean isEnabled = false;
    private IBlueToothState mStateCallback;
    private BroadcastReceiver receiver;
    private static BlueToother ins = new BlueToother();
    private int leftTryTimes;
    private Handler mHandler;
    Runnable mTryConnectBlueRunnable = null;
    private BroadcastReceiver registerBlueStatusReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (null != intent) {
                String action = intent.getAction();
                GenseeLog.d(BlueToother.TAG, "Aaction name = " + action);
                if ("android.bluetooth.device.action.FOUND".equals(action)) {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    GenseeLog.d(BlueToother.TAG, "ACTION_FOUND device name = " + device.getName());
                } else if (!"android.bluetooth.device.action.BOND_STATE_CHANGED".equals(action)) {
                    if ("android.bluetooth.device.action.ACL_CONNECTED".equals(action)) {
                        BlueToother.this.tryConnectBlueTooth(context.getApplicationContext(), 2);
                    } else if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(action)) {
                        ThreadPool.getInstance().execute(new Runnable(){

                            @Override
                            public void run() {
                                if (null != BlueToother.this.mHandler) {
                                    BlueToother.this.mHandler.removeCallbacks(BlueToother.this.mTryConnectBlueRunnable);
                                }
                                BlueToother.this.release(BlueToother.this.sdkFlags);
                            }
                        });
                    } else if ("android.bluetooth.adapter.action.SCAN_MODE_CHANGED".equals(action)) {
                        BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    } else if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(action)) {
                        int status = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
                        int preStatus = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -1);
                        GenseeLog.d(BlueToother.TAG, "ACTION_STATE_CHANGED device status = " + status + " preStatus = " + preStatus);
                        if (status != 11 && status != 12) {
                            if (status == 10) {
                                ThreadPool.getInstance().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        BlueToother.this.release(BlueToother.this.sdkFlags);
                                    }
                                });
                            } else if (status == 13) {
                                // empty if block
                            }
                        }
                    }
                }
            }
        }
    };
    private IBlueToothState blueToothState;

    private BlueToother() {
    }

    public static BlueToother getIns() {
        return ins;
    }

    public void init(Context context, int sdkFlag) {
        this.sdkFlags |= sdkFlag;
        if (context != null && this.state == 0) {
            context = context.getApplicationContext();
            this.manager = (AudioManager)context.getSystemService("audio");
            try {
                boolean permssion = false;
                PackageManager pm = context.getPackageManager();
                String pkgName = context.getPackageName();
                boolean bl = permssion = 0 == pm.checkPermission("android.permission.BLUETOOTH", pkgName) && 0 == pm.checkPermission("android.permission.BLUETOOTH_ADMIN", pkgName);
                if (permssion) {
                    BluetoothAdapter adapter = null;
                    if (Build.VERSION.SDK_INT <= 17) {
                        adapter = BluetoothAdapter.getDefaultAdapter();
                    } else {
                        BluetoothManager btMgr = (BluetoothManager)context.getSystemService("bluetooth");
                        if (btMgr != null) {
                            adapter = btMgr.getAdapter();
                        }
                    }
                    this.isEnabled = adapter != null && adapter.isEnabled();
                }
                GenseeLog.d(TAG, "init isEnable = " + this.isEnabled + " permssion = " + permssion);
                if (this.isEnabled && this.manager.isBluetoothScoAvailableOffCall()) {
                    this.rigister(context, this.receiver);
                    this.registerBlueStatusBroadcastReceiver(context);
                    this.manager.startBluetoothSco();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void rigister(Context context, BroadcastReceiver receiver) {
        if (receiver == null) {
            receiver = new BroadcastReceiver(){

                public void onReceive(final Context context, Intent intent) {
                    if (intent != null && "android.media.ACTION_SCO_AUDIO_STATE_UPDATED".equals(intent.getAction())) {
                        BlueToother.this.state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", 0);
                        int statePre = intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", 0);
                        switch (BlueToother.this.state) {
                            case 1: {
                                GenseeLog.d(BlueToother.TAG, "onReceive SCO_AUDIO_STATE_CONNECTED " + BlueToother.this.state + " preState = " + statePre);
                                ThreadPool.getInstance().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        BlueToother.this.manager.setBluetoothScoOn(true);
                                        BlueToother.this.manager.setMode(3);
                                        if (null != BlueToother.this.mHandler && null != BlueToother.this.mTryConnectBlueRunnable) {
                                            BlueToother.this.mHandler.removeCallbacks(BlueToother.this.mTryConnectBlueRunnable);
                                        }
                                        context.unregisterReceiver(BlueToother.this.receiver);
                                        BlueToother.this.receiver = null;
                                        GenseeLog.d(BlueToother.TAG, "onReceive SCO_AUDIO_STATE_CONNECTED startBlue");
                                    }
                                });
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 0: {
                                BlueToother.this.manager.setMode(0);
                                break;
                            }
                            case -1: {
                                GenseeLog.d(BlueToother.TAG, "onReceive SCO_AUDIO_STATE_ERROR " + BlueToother.this.state + " preState = " + statePre);
                                BlueToother.this.manager.stopBluetoothSco();
                            }
                        }
                    }
                }
            };
            IntentFilter f = new IntentFilter();
            f.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            context.registerReceiver(receiver, f, TAG, null, 4);
        }
    }

    private void tryConnectBlueTooth(final Context context, final int tryTimes) {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (tryTimes == 0) {
                    if (null != BlueToother.this.mHandler && null != BlueToother.this.mTryConnectBlueRunnable) {
                        BlueToother.this.mHandler.removeCallbacks(BlueToother.this.mTryConnectBlueRunnable);
                    }
                    if (null != BlueToother.this.receiver) {
                        context.unregisterReceiver(BlueToother.this.receiver);
                        BlueToother.this.receiver = null;
                    }
                    return;
                }
                GenseeLog.d(BlueToother.TAG, "tryConnectBlueTooth begin");
                BlueToother.this.init(context, BlueToother.this.sdkFlags);
                GenseeLog.d(BlueToother.TAG, "tryConnectBlueTooth end");
                if (null == BlueToother.this.mTryConnectBlueRunnable) {
                    BlueToother.this.mTryConnectBlueRunnable = new Runnable(){

                        @Override
                        public void run() {
                            BlueToother.this.release(BlueToother.this.sdkFlags);
                            BlueToother.this.tryConnectBlueTooth(context, BlueToother.this.leftTryTimes);
                        }
                    };
                }
                BlueToother.this.mHandler.postDelayed(BlueToother.this.mTryConnectBlueRunnable, 3000L);
                BlueToother.this.leftTryTimes = tryTimes - 1;
            }
        });
    }

    public void registerBlueStatusBroadcastReceiver(Context context) {
        if (null != this.registerBlueStatusReceiver) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            intentFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
            intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
            context.registerReceiver(this.registerBlueStatusReceiver, intentFilter, 4);
        }
    }

    public boolean isConnected() {
        return this.state == 1;
    }

    public void setBluetoothScoOn(boolean isOn) {
        if (this.manager != null) {
            this.manager.setBluetoothScoOn(isOn);
        }
    }

    public void release(int sdkFlag) {
        this.sdkFlags &= ~sdkFlag;
        GenseeLog.d(TAG, "release flags = " + this.sdkFlags);
        if (this.sdkFlags == 0) {
            try {
                this.state = 0;
                if (this.isEnabled && this.manager != null) {
                    this.manager.setBluetoothScoOn(false);
                    this.manager.stopBluetoothSco();
                }
                this.isEnabled = false;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void setOnBlueToothState(IBlueToothState blueToothState) {
        this.blueToothState = blueToothState;
    }

    public static interface IBlueToothState {
        public void onBlueTurnOn();

        public void onBlueTurnOff();
    }
}

