/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.holder.qa.impl;

import android.content.Context;
import com.gensee.db.PlayerQaDataBaseManager;
import com.gensee.entity.qa.RtQaMsg;
import com.gensee.utils.GenseeLog;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class QaMsgQueue {
    protected ReentrantReadWriteLock mLock;
    private PlayerQaDataBaseManager dataBaseManager;
    private static QaMsgQueue msgManager = null;
    private static final int READ_PER_COUNT = 200;
    private static final int QUEUE_QA_MAX_LENGH = 200;
    private List<RtQaMsg> msgList = new ArrayList<RtQaMsg>();
    private OnQaHolderListener onQaHolderListener;
    private boolean bLatest = true;
    private boolean bSelfLatest = true;
    private List<RtQaMsg> selfMsgList = new ArrayList<RtQaMsg>();
    private long selfUserId = -1L;
    private int nMsgCount = 0;
    private Map<String, RtQaMsg> cancelList = new HashMap<String, RtQaMsg>();

    public void setMsgCount(int nMsgCount) {
        this.nMsgCount = nMsgCount;
    }

    public int getMsgCount() {
        return this.nMsgCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QaMsgQueue getIns() {
        Class<QaMsgQueue> clazz = QaMsgQueue.class;
        synchronized (QaMsgQueue.class) {
            if (null == msgManager) {
                msgManager = new QaMsgQueue();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return msgManager;
        }
    }

    public void setOnQaHolderListener(OnQaHolderListener onQaHolderListener) {
        this.onQaHolderListener = onQaHolderListener;
    }

    public QaMsgQueue() {
        this.mLock = new ReentrantReadWriteLock();
    }

    @Deprecated
    public void initMsgDbHelper(PlayerQaDataBaseManager playerDataBaseManager) {
        this.dataBaseManager = playerDataBaseManager;
        this.nMsgCount = 0;
        GenseeLog.i("QaMsgQueue", "initMsgDbHelper dataBaseManager = " + this.dataBaseManager);
    }

    public void initMsgDb(Context context) {
        if (context != null) {
            this.dataBaseManager = new PlayerQaDataBaseManager(context.getApplicationContext());
        } else {
            GenseeLog.w("QaMsgQueue", "initMsgDb context is null");
        }
        this.nMsgCount = 0;
    }

    public void addCancelMsg(RtQaMsg rtQaMsg) {
        this.mLock.writeLock().lock();
        try {
            this.cancelList.put(rtQaMsg.getQuestId(), rtQaMsg);
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQaMsgList(List<RtQaMsg> dataList) {
        this.mLock.writeLock().lock();
        try {
            boolean bl;
            ArrayList<RtQaMsg> cancelDeleteList = new ArrayList<RtQaMsg>();
            for (RtQaMsg rtQaMsg : dataList) {
                RtQaMsg cancelMsg = this.cancelList.get(rtQaMsg.getQuestId());
                if (null == cancelMsg || rtQaMsg.getTimestamp() > cancelMsg.getTimestamp()) continue;
                long selfUserId = 0L;
                if (null != this.onQaHolderListener) {
                    selfUserId = this.onQaHolderListener.getSelfUserId();
                }
                if (selfUserId == cancelMsg.getQuestOwnerId() && "".equals(rtQaMsg.getAnswer())) continue;
                cancelDeleteList.add(rtQaMsg);
            }
            dataList.removeAll(cancelDeleteList);
            if (this.selfUserId > 0L) {
                ArrayList<RtQaMsg> selfUserList = new ArrayList<RtQaMsg>();
                for (RtQaMsg rtQaMsg : dataList) {
                    if (this.selfUserId <= 0L || rtQaMsg.getQuestOwnerId() != this.selfUserId) continue;
                    selfUserList.add(rtQaMsg);
                }
                if (selfUserList.size() > 0) {
                    this.processSelfList(selfUserList);
                }
            }
            int nSize = dataList.size();
            boolean bl2 = bl = null != this.onQaHolderListener && this.onQaHolderListener.isLvBottom();
            if (this.bLatest) {
                if (nSize >= 200) {
                    if (bl) {
                        int index = nSize - 200;
                        this.msgList.clear();
                        for (int i = index; i < nSize; ++i) {
                            this.msgList.add(dataList.get(i));
                        }
                    } else {
                        int otherSize = 200 - this.msgList.size();
                        for (int i = 0; i < otherSize; ++i) {
                            this.msgList.add(dataList.get(i));
                        }
                        this.bLatest = false;
                    }
                } else {
                    int nTotalSize = nSize + this.msgList.size();
                    if (nTotalSize <= 200) {
                        this.msgList.addAll(dataList);
                    } else if (bl) {
                        int nOtherSize = nTotalSize - 200;
                        ArrayList<RtQaMsg> deleteList = new ArrayList<RtQaMsg>();
                        for (int i = 0; i < nOtherSize; ++i) {
                            deleteList.add(this.msgList.get(i));
                        }
                        this.msgList.removeAll(deleteList);
                        this.msgList.addAll(dataList);
                    } else {
                        int otherSize = 200 - this.msgList.size();
                        for (int i = 0; i < otherSize; ++i) {
                            this.msgList.add(dataList.get(i));
                        }
                        this.bLatest = false;
                    }
                }
            }
            if (!this.bLatest || !bl) {
                for (RtQaMsg msg : dataList) {
                    msg.setReadFlag(1);
                }
            }
            if (this.dataBaseManager != null) {
                this.dataBaseManager.insertQaMsgList(dataList);
            }
            this.processNewMsg(dataList.size());
            this.refreshMsg();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    private void processNewMsg(int nCount) {
        if (null != this.onQaHolderListener) {
            this.nMsgCount = this.bLatest && this.onQaHolderListener.isLvBottom() ? 0 : (this.nMsgCount += nCount);
            this.onQaHolderListener.onNewMsgCount(this.nMsgCount);
        }
    }

    private void refreshMsg() {
        if (null != this.onQaHolderListener) {
            this.onQaHolderListener.refreshMsg(new ArrayList<RtQaMsg>(this.msgList), this.bLatest);
        }
    }

    public void getLatestQaMsgsList() {
        this.mLock.writeLock().lock();
        try {
            this.msgList.clear();
            this.msgList.addAll(this._getQaLatestMsgs());
            this.bLatest = true;
            this.processNewMsg(0);
            this.refreshMsg();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    public void getMsgList() {
        this.mLock.writeLock().lock();
        try {
            this.refreshMsg();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRtQaMsgReadFlag(long time) {
        this.mLock.writeLock().lock();
        try {
            if (null != this.dataBaseManager) {
                this.dataBaseManager.updateRtQaMsgReadFlag(time);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelQaMsg(String id, boolean bSelf) {
        boolean bTrue = false;
        this.mLock.writeLock().lock();
        try {
            RtQaMsg cancelMsg = this.cancelList.get(id);
            int nNewReadCount = this.queryRtQaMsgById(id, bSelf, null == cancelMsg ? Calendar.getInstance().getTimeInMillis() : cancelMsg.getTimestamp());
            this.nMsgCount -= nNewReadCount;
            this.processNewMsg(0);
            this.removeRtQaMsgById(id, bSelf, null == cancelMsg ? Calendar.getInstance().getTimeInMillis() : cancelMsg.getTimestamp());
            this.cancelMsg(id, bSelf);
            this.cancelSelfMsg(id, bSelf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
        return bTrue;
    }

    private void cancelMsg(String id, boolean bSelf) {
        int count = 0;
        ArrayList<RtQaMsg> deleteList = new ArrayList<RtQaMsg>();
        for (RtQaMsg tmsg : this.msgList) {
            RtQaMsg cancelMsg;
            if (tmsg == null || !tmsg.getQuestId().equals(id) || bSelf && "".equals(tmsg.getAnswer()) || null != (cancelMsg = this.cancelList.get(id)) && tmsg.getTimestamp() > cancelMsg.getTimestamp()) continue;
            ++count;
            deleteList.add(tmsg);
        }
        this.msgList.removeAll(deleteList);
        if (count > 0) {
            int nSize = this.msgList.size();
            int nReadSize = 200 - nSize;
            if (nSize <= 0) {
                this.msgList = this._getQaLatestMsgs();
                this.bLatest = true;
            } else {
                List<RtQaMsg> tmpList = this.queryQaMsgsListNext(this.msgList.get(nSize - 1).getTimestamp());
                this.msgList.addAll(tmpList);
                if (tmpList.size() < nReadSize) {
                    this.bLatest = true;
                } else {
                    RtQaMsg newMsg = tmpList.get(tmpList.size() - 1);
                    RtQaMsg latestMsg = null;
                    if (this.dataBaseManager != null) {
                        latestMsg = this.dataBaseManager.getLatestQaMsg();
                    }
                    this.bLatest = null != latestMsg ? latestMsg.getTimestamp() == newMsg.getTimestamp() : true;
                }
            }
        }
        if (null != this.onQaHolderListener) {
            this.onQaHolderListener.onCancelMsg(this.msgList, this.bLatest);
        }
    }

    private void cancelSelfMsg(String id, boolean bSelf) {
        if (this.selfUserId <= 0L) {
            return;
        }
        int count = 0;
        ArrayList<RtQaMsg> deleteList = new ArrayList<RtQaMsg>();
        for (RtQaMsg tmsg : this.selfMsgList) {
            RtQaMsg cancelMsg;
            if (tmsg == null || !tmsg.getQuestId().equals(id) || bSelf && "".equals(tmsg.getAnswer()) || null != (cancelMsg = this.cancelList.get(id)) && tmsg.getTimestamp() > cancelMsg.getTimestamp()) continue;
            ++count;
            deleteList.add(tmsg);
        }
        this.selfMsgList.removeAll(deleteList);
        if (count > 0 && this.dataBaseManager != null) {
            int nSize = this.selfMsgList.size();
            int nReadSize = 200 - nSize;
            if (nSize <= 0) {
                this.selfMsgList = this.dataBaseManager.getLatestQaMsgsByOwnerId(200, this.selfUserId);
                this.bSelfLatest = true;
            } else {
                List<RtQaMsg> tmpList = this.dataBaseManager.queryQaMsgsByOwnerIdLimitNext(this.selfUserId, nReadSize, this.selfMsgList.get(nSize - 1).getTimestamp());
                this.selfMsgList.addAll(tmpList);
                if (tmpList.size() < nReadSize) {
                    this.bSelfLatest = true;
                } else {
                    RtQaMsg latestMsg;
                    RtQaMsg newMsg = tmpList.get(tmpList.size() - 1);
                    List<RtQaMsg> latestList = this.dataBaseManager.getLatestQaMsgsByOwnerId(1, this.selfUserId);
                    this.bSelfLatest = latestList.size() > 0 ? (latestMsg = latestList.get(0)).getTimestamp() == newMsg.getTimestamp() : true;
                }
            }
        }
        if (null != this.onQaHolderListener && this.selfUserId > 0L) {
            this.onQaHolderListener.onCancelSelfMsg(this.selfMsgList, this.bSelfLatest);
        }
    }

    private List<RtQaMsg> _getQaLatestMsgs() {
        ArrayList<RtQaMsg> msgs = new ArrayList<RtQaMsg>();
        if (null != this.dataBaseManager) {
            msgs.addAll(this.dataBaseManager.getLatestQaMsgsList(200));
        }
        return msgs;
    }

    private List<RtQaMsg> queryQaMsgsLimitPre(long timeMillions) {
        ArrayList<RtQaMsg> msgs = new ArrayList<RtQaMsg>();
        if (null != this.dataBaseManager) {
            msgs.addAll(this.dataBaseManager.queryQaMsgsLimitPre(200, timeMillions));
        }
        return msgs;
    }

    private List<RtQaMsg> queryQaMsgsListNext(long timeMillions) {
        ArrayList<RtQaMsg> returnList = new ArrayList<RtQaMsg>();
        if (null != this.dataBaseManager) {
            returnList.addAll(this.dataBaseManager.queryQaMsgsLimitNext(200, timeMillions));
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageFresh() {
        this.mLock.writeLock().lock();
        try {
            int nMsgSize = this.msgList.size();
            if (nMsgSize > 0) {
                RtQaMsg firstMsg = this.msgList.get(0);
                List<RtQaMsg> tmpList = this.queryQaMsgsLimitPre(firstMsg.getTimestamp());
                int tempSize = tmpList.size();
                if (nMsgSize + tempSize > 200) {
                    int nDeleteCount = nMsgSize + tempSize - 200;
                    ArrayList<RtQaMsg> deleteList = new ArrayList<RtQaMsg>();
                    for (int i = nMsgSize - 1; i >= nMsgSize - nDeleteCount; --i) {
                        deleteList.add(this.msgList.get(i));
                    }
                    this.msgList.removeAll(deleteList);
                    deleteList.clear();
                    deleteList = null;
                    this.bLatest = false;
                }
                this.msgList.addAll(0, tmpList);
                Object var3_4 = null;
            }
            if (null != this.onQaHolderListener) {
                this.onQaHolderListener.onPullMsg(this.msgList, this.bLatest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageLoadMore() {
        this.mLock.writeLock().lock();
        try {
            int nMsgSize = this.msgList.size();
            if (nMsgSize > 0) {
                RtQaMsg lastMsg = this.msgList.get(nMsgSize - 1);
                List<RtQaMsg> tmpList = this.queryQaMsgsListNext(lastMsg.getTimestamp());
                int tempSize = tmpList.size();
                if (tempSize < 200) {
                    this.bLatest = true;
                } else if (tempSize == 200) {
                    boolean bTrue = false;
                    RtQaMsg nCurLatestMsg = tmpList.get(tempSize - 1);
                    RtQaMsg nDbLatestMsg = this.dataBaseManager.getLatestQaMsg();
                    bTrue = nDbLatestMsg == null ? true : nCurLatestMsg.getTimestamp() == nDbLatestMsg.getTimestamp();
                    this.bLatest = bTrue;
                }
                if (nMsgSize + tempSize > 200) {
                    int nDeleteCount = nMsgSize + tempSize - 200;
                    ArrayList<RtQaMsg> deleteList = new ArrayList<RtQaMsg>();
                    for (int i = 0; i < nDeleteCount; ++i) {
                        deleteList.add(this.msgList.get(i));
                    }
                    this.msgList.removeAll(deleteList);
                    deleteList.clear();
                    deleteList = null;
                }
                this.msgList.addAll(tmpList);
            }
            if (null != this.onQaHolderListener) {
                this.onQaHolderListener.onLoadMsg(this.msgList, this.bLatest);
                this.processNewMsg(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    public void closedb() {
        this.mLock.writeLock().lock();
        try {
            if (null != this.dataBaseManager) {
                this.dataBaseManager.closeDb();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    public void clear() {
        if (null != this.onQaHolderListener) {
            this.onQaHolderListener.clear();
        }
        this.mLock.writeLock().lock();
        try {
            this.cancelList.clear();
            this.msgList.clear();
            this.selfMsgList.clear();
            this.bLatest = true;
            this.bSelfLatest = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    private int queryRtQaMsgById(String uuid, boolean bSelf, long cancelTime) {
        int nReturn = 0;
        if (null != this.dataBaseManager) {
            nReturn = this.dataBaseManager.queryRtQaMsgNewsByUUId(uuid, bSelf, cancelTime);
        }
        return nReturn;
    }

    private int removeRtQaMsgById(String uuid, boolean bSelf, long cancelTime) {
        int nReturn = -1;
        if (null != this.dataBaseManager) {
            nReturn = this.dataBaseManager.removeRtQaMsgByUUID(uuid, bSelf, cancelTime);
        }
        return nReturn;
    }

    public void release() {
        if (null != this.onQaHolderListener) {
            this.onQaHolderListener.clear();
        }
        this.mLock.writeLock().lock();
        try {
            this.cancelList.clear();
            if (null != this.dataBaseManager) {
                this.dataBaseManager.removeAllQaMsgs();
            }
            this.msgList.clear();
            this.selfMsgList.clear();
            this.bLatest = true;
            this.bSelfLatest = true;
            this.nMsgCount = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    private void processSelfList(List<RtQaMsg> selfUserList) {
        boolean bBottom;
        int nSize = selfUserList.size();
        boolean bl = bBottom = null != this.onQaHolderListener && this.onQaHolderListener.isSelfLvBottom();
        if (this.bSelfLatest) {
            if (nSize >= 200) {
                if (bBottom) {
                    int index = nSize - 200;
                    this.selfMsgList.clear();
                    for (int i = index; i < nSize; ++i) {
                        this.selfMsgList.add(selfUserList.get(i));
                    }
                } else {
                    int otherSize = 200 - this.selfMsgList.size();
                    for (int i = 0; i < otherSize; ++i) {
                        this.selfMsgList.add(selfUserList.get(i));
                    }
                    this.bSelfLatest = false;
                }
            } else {
                int nTotalSize = nSize + this.selfMsgList.size();
                if (nTotalSize <= 200) {
                    this.selfMsgList.addAll(selfUserList);
                } else if (bBottom) {
                    int nOtherSize = nTotalSize - 200;
                    ArrayList<RtQaMsg> deleteList = new ArrayList<RtQaMsg>();
                    for (int i = 0; i < nOtherSize; ++i) {
                        deleteList.add(this.selfMsgList.get(i));
                    }
                    this.selfMsgList.removeAll(deleteList);
                    this.selfMsgList.addAll(selfUserList);
                } else {
                    int otherSize = 200 - this.selfMsgList.size();
                    for (int i = 0; i < otherSize; ++i) {
                        this.selfMsgList.add(selfUserList.get(i));
                    }
                    this.bSelfLatest = false;
                }
            }
        }
        if (null != this.onQaHolderListener && this.selfUserId > 0L) {
            this.onQaHolderListener.refreshSelfMsg(this.selfMsgList, this.bSelfLatest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSelfQaLatestMsg(long selfUserId) {
        this.mLock.writeLock().lock();
        try {
            this.selfUserId = selfUserId;
            this.selfMsgList.clear();
            this.selfMsgList.addAll(this.dataBaseManager.getLatestQaMsgsByOwnerId(200, selfUserId));
            this.bSelfLatest = true;
            this.refreshSelfMsg();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    private void refreshSelfMsg() {
        if (null != this.onQaHolderListener && this.selfUserId > 0L) {
            this.onQaHolderListener.refreshSelfMsg(this.selfMsgList, this.bSelfLatest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSelfMessageFresh(long selfId) {
        this.mLock.writeLock().lock();
        try {
            int nMsgSize = this.selfMsgList.size();
            if (nMsgSize > 0) {
                int tempSize;
                RtQaMsg firstMsg = this.selfMsgList.get(0);
                List<RtQaMsg> tmpList = null;
                if (this.dataBaseManager != null) {
                    tmpList = this.dataBaseManager.queryQaMsgsByOwnerIdLimitPre(selfId, 200, firstMsg.getTimestamp());
                }
                int n = tempSize = tmpList == null ? 0 : tmpList.size();
                if (nMsgSize + tempSize > 200) {
                    int nDeleteCount = nMsgSize + tempSize - 200;
                    ArrayList<RtQaMsg> deleteList = new ArrayList<RtQaMsg>();
                    for (int i = nMsgSize - 1; i >= nMsgSize - nDeleteCount; --i) {
                        deleteList.add(this.selfMsgList.get(i));
                    }
                    this.selfMsgList.removeAll(deleteList);
                    deleteList.clear();
                    deleteList = null;
                    this.bSelfLatest = false;
                }
                if (tmpList != null) {
                    this.selfMsgList.addAll(0, tmpList);
                    tmpList = null;
                }
            }
            if (null != this.onQaHolderListener && this.selfUserId > 0L) {
                this.onQaHolderListener.onPullSelfMsg(this.selfMsgList, this.bSelfLatest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSelfMessageLoadMore(long selfId) {
        this.mLock.writeLock().lock();
        try {
            int nMsgSize = this.selfMsgList.size();
            if (nMsgSize > 0 && this.dataBaseManager != null) {
                int tempSize;
                RtQaMsg lastMsg = this.selfMsgList.get(nMsgSize - 1);
                List<RtQaMsg> tmpList = null;
                tmpList = this.dataBaseManager.queryQaMsgsByOwnerIdLimitNext(selfId, 200, lastMsg.getTimestamp());
                int n = tempSize = tmpList == null ? 0 : tmpList.size();
                if (tempSize < 200) {
                    this.bSelfLatest = true;
                } else if (tempSize == 200) {
                    boolean bTrue = false;
                    RtQaMsg nCurLatestMsg = tmpList.get(tempSize - 1);
                    RtQaMsg nDbLatestMsg = this.dataBaseManager.getLatestQaMsg();
                    bTrue = nDbLatestMsg == null ? true : nCurLatestMsg.getTimestamp() == nDbLatestMsg.getTimestamp();
                    this.bSelfLatest = bTrue;
                }
                if (nMsgSize + tempSize > 200) {
                    int nDeleteCount = nMsgSize + tempSize - 200;
                    ArrayList<RtQaMsg> deleteList = new ArrayList<RtQaMsg>();
                    for (int i = 0; i < nDeleteCount; ++i) {
                        deleteList.add(this.selfMsgList.get(i));
                    }
                    this.selfMsgList.removeAll(deleteList);
                    deleteList.clear();
                    deleteList = null;
                }
                if (tmpList != null) {
                    this.selfMsgList.addAll(tmpList);
                }
            }
            if (null != this.onQaHolderListener && this.selfUserId > 0L) {
                this.onQaHolderListener.onLoadSelfMsg(this.selfMsgList, this.bSelfLatest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    public void resetSelfList() {
        this.selfUserId = -1L;
    }

    public boolean isQaLatest() {
        this.mLock.readLock().lock();
        try {
            boolean bl = this.bLatest;
            return bl;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    public boolean isSelfQaLatest() {
        this.mLock.readLock().lock();
        try {
            boolean bl = this.bSelfLatest;
            return bl;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    public long getSelfUserId() {
        this.mLock.readLock().lock();
        try {
            long l = this.selfUserId;
            return l;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    public static interface OnQaHolderListener {
        public boolean isLvBottom();

        public boolean isSelfLvBottom();

        public void refreshMsg(List<RtQaMsg> var1, boolean var2);

        public void onPullMsg(List<RtQaMsg> var1, boolean var2);

        public void onLoadMsg(List<RtQaMsg> var1, boolean var2);

        public void refreshSelfMsg(List<RtQaMsg> var1, boolean var2);

        public void onPullSelfMsg(List<RtQaMsg> var1, boolean var2);

        public void onLoadSelfMsg(List<RtQaMsg> var1, boolean var2);

        public void onCancelMsg(List<RtQaMsg> var1, boolean var2);

        public void onCancelSelfMsg(List<RtQaMsg> var1, boolean var2);

        public void onNewMsgCount(int var1);

        public long getSelfUserId();

        public void clear();
    }
}

