/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.holder.qa.impl;

import com.gensee.entity.qa.RtQaMsg;
import com.gensee.holder.qa.impl.QaMsgQueue;
import com.gensee.utils.GenseeLog;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class AbstractQaImpl {
    private Thread qaMsgThread = null;
    private AtomicBoolean bRunning = new AtomicBoolean(false);
    private Object object = new Object();
    private Object objQaList = new Object();
    private long nStartTime = 0L;
    private static final int NEW_QA_DELAY_TIME = 1000;
    private List<RtQaMsg> qaMsgList = new ArrayList<RtQaMsg>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMsg(RtQaMsg msg) {
        this.addQaMsg(msg);
        if (null == this.qaMsgThread || !this.bRunning.get()) {
            this.bRunning.set(true);
            this.qaMsgThread = new QaMsgThread();
            this.qaMsgThread.start();
        }
        Object object = this.object;
        synchronized (object) {
            this.object.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addQaMsg(RtQaMsg msg) {
        Object object = this.objQaList;
        synchronized (object) {
            this.qaMsgList.add(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RtQaMsg> getAndClearMsgs() {
        ArrayList msg = null;
        Object object = this.objQaList;
        synchronized (object) {
            msg = new ArrayList(this.qaMsgList);
            this.qaMsgList.clear();
        }
        return null == msg ? new ArrayList() : msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMsg() {
        long nEndTime = Calendar.getInstance().getTimeInMillis();
        long nTimelong = nEndTime - this.nStartTime;
        if (nTimelong >= 1000L) {
            this.nStartTime = nEndTime;
            List<RtQaMsg> msgList = null;
            Object object = this.object;
            synchronized (object) {
                int nCount = this.qaMsgList.size();
                GenseeLog.d("QaImpl", "handleMsg qa nCount = " + nCount);
                if (nCount > 0) {
                    msgList = this.getAndClearMsgs();
                } else {
                    try {
                        this.object.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (null != msgList && msgList.size() > 0) {
                QaMsgQueue.getIns().addQaMsgList(msgList);
            }
        } else {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void release() {
        if (null != this.qaMsgList) {
            this.qaMsgList.clear();
        }
        if (null != this.qaMsgThread && !this.qaMsgThread.isInterrupted()) {
            this.qaMsgThread.interrupt();
        }
        this.bRunning.set(false);
        QaMsgQueue.getIns().clear();
        QaMsgQueue.getIns().closedb();
    }

    private class QaMsgThread
    extends Thread {
        private QaMsgThread() {
        }

        @Override
        public void run() {
            while (AbstractQaImpl.this.bRunning.get()) {
                AbstractQaImpl.this.handleMsg();
            }
        }
    }
}

