/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.entity;

import android.content.Context;
import com.gensee.entity.BaseMsg;
import java.util.UUID;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QAMsg
extends BaseMsg {
    private static final long serialVersionUID = -4222713026296454093L;
    private static final String QA = "<module name=\"qa\" userid=\"%s\"><qamsg id=\"%s\" name=\"%s\"><![CDATA[%s]]></qamsg></module>";
    private long timestamp;
    private String questId;
    private long questTimgstamp;
    private String questOwnerName;
    private long questOwnerId;
    private String question;
    private String answerOwner;
    private String answerId;
    private long answerTimestamp;
    private String answer;
    private boolean isCancel = false;

    public QAMsg(String type) {
        this.setModule("qa");
        this.setType(type);
    }

    public QAMsg() {
        this("qa");
    }

    public QAMsg(String qId, String question, String qOwner, String aId, String answer, String aOwner, long qTime, long aTime, long qOwnerId, boolean isCancel) {
        this();
        this.questId = qId;
        this.question = question;
        this.questOwnerName = qOwner;
        this.answerId = aId;
        this.answer = answer;
        this.answerOwner = aOwner;
        this.questTimgstamp = qTime;
        this.answerTimestamp = aTime;
        this.questOwnerId = qOwnerId;
        this.isCancel = isCancel;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getQuestId() {
        return this.questId;
    }

    public void setQuestId(String questId) {
        this.questId = questId;
    }

    public long getQuestTimgstamp() {
        return this.questTimgstamp;
    }

    public void setQuestTimgstamp(long questTimgstamp) {
        this.questTimgstamp = questTimgstamp;
    }

    public String getQuestOwnerName() {
        return this.questOwnerName;
    }

    public void setQuestOwnerName(String questOwnerName) {
        this.questOwnerName = questOwnerName;
    }

    public long getQuestOwnerId() {
        return this.questOwnerId;
    }

    public void setQuestOwnerId(long questOwnerid) {
        this.questOwnerId = questOwnerid;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public String getAnswerUser() {
        return this.answerOwner;
    }

    public void setAnswerUser(String answerUser) {
        this.answerOwner = answerUser;
    }

    public long getAnswerTimestamp() {
        return this.answerTimestamp;
    }

    public void setAnswerTimestamp(long answerTimestamp) {
        this.answerTimestamp = answerTimestamp;
    }

    public String getAnswer() {
        return this.answer;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public String getAnswerOwner() {
        return this.answerOwner;
    }

    public void setAnswerOwner(String answerOwner) {
        this.answerOwner = answerOwner;
    }

    public String getAnswerId() {
        return this.answerId;
    }

    public void setAnswerId(String answerId) {
        this.answerId = answerId;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    @Override
    protected BaseMsg onXmlNode(Context c, Node n) {
        if (c == null || n == null) {
            return null;
        }
        String type = this.getType();
        if ("qa".equals(type)) {
            this.timestamp = QAMsg.getNodeAttrLong(n, "timestamp");
            NodeList nl = n.getChildNodes();
            if (nl != null) {
                int size = nl.getLength();
                for (int i = 0; i < size; ++i) {
                    Node node = nl.item(i);
                    if (node == null) continue;
                    String nodeName = node.getNodeName();
                    if ("question".equals(nodeName)) {
                        this.onQuestion(node);
                        continue;
                    }
                    if (!"answer".equals(nodeName)) continue;
                    this.onanswer(node);
                }
            }
        } else if ("qahistroy".equals(type)) {
            this.questTimgstamp = QAMsg.getNodeAttrLong(n, "questiontimestamp");
            this.questId = QAMsg.getNodeAttrString(n, "id");
            this.question = QAMsg.getNodeAttrString(n, "question");
            this.questOwnerName = QAMsg.getNodeAttrString(n, "questionowner");
            this.questOwnerId = QAMsg.getNodeAttrLong(n, "questionownerid");
            this.answerOwner = QAMsg.getNodeAttrString(n, "answerowner");
            this.answerId = QAMsg.getNodeAttrString(n, "answerid");
            this.answer = QAMsg.getNodeAttrString(n, "answer");
            this.answerTimestamp = QAMsg.getNodeAttrLong(n, "qaanswertimestamp");
        }
        return this;
    }

    private void onQuestion(Node node) {
        this.questId = QAMsg.getNodeAttrString(node, "id");
        this.questTimgstamp = QAMsg.getNodeAttrLong(node, "timestamp");
        this.questOwnerName = QAMsg.getNodeAttrString(node, "user");
        this.questOwnerId = QAMsg.getNodeAttrLong(node, "questionownerid");
        this.question = node.getTextContent();
        this.question = this.question == null ? "" : this.question.trim();
    }

    private void onanswer(Node node) {
        this.answerOwner = QAMsg.getNodeAttrString(node, "user");
        this.answerTimestamp = QAMsg.getNodeAttrLong(node, "timestamp");
        this.answer = node.getTextContent();
        this.answer = this.answer == null ? "" : this.answer.trim();
    }

    @Override
    protected String getXml() {
        if (this.questOwnerId == 0L) {
            return "";
        }
        if (this.questId == null || "".equals(this.questId)) {
            this.questId = UUID.randomUUID().toString();
        }
        if (this.questOwnerName == null || "".equals(this.questOwnerName)) {
            return "";
        }
        if (this.question == null || "".equals(this.question)) {
            return "";
        }
        return String.format(QA, this.questOwnerId, this.questId, this.questOwnerName, this.question);
    }

    @Override
    public String toString() {
        return "QAMsg [timestamp=" + this.timestamp + ", questId=" + this.questId + ", questTimgstamp=" + this.questTimgstamp + ", questOwnerName=" + this.questOwnerName + ", questOwnerId=" + this.questOwnerId + ", question=" + this.question + ", answerOwner=" + this.answerOwner + ", answerId=" + this.answerId + ", answerTimestamp=" + this.answerTimestamp + ", answer=" + this.answer + ", toString()=" + super.toString() + "]";
    }
}

