/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.entity;

import android.content.Context;
import com.gensee.common.GenseeConfig;
import com.gensee.entity.BaseMsg;
import com.gensee.entity.EmsMsg;
import com.gensee.utils.StringUtil;
import org.w3c.dom.Node;

public class ChatMsg
extends EmsMsg {
    private static final long serialVersionUID = 808834629165790017L;
    public static final int CHAT_MSG_TYPE_PUBLIC = 0;
    public static final int CHAT_MSG_TYPE_PANELIST = 1;
    public static final int CHAT_MSG_TYPE_PRIVATE = 2;
    public static final String CONTENT_TYPE_PICTURE = "picture";
    public static final String CONTENT_TYPE_TEXT = "text";
    private boolean isGroup = false;
    private String groupId = "";
    private String content;
    private String richText;
    private long receiverId;
    private int chatId;
    private int chatMsgType = -1;
    private String id;
    private String censorType;
    private String contentType = "text";
    private String sendRichText;
    private long timeStamp;
    private String subClassId = "";

    public ChatMsg() {
        super("chat");
    }

    public ChatMsg(long senderId, String senderName, String text, String rich, boolean isGroup) {
        this();
        this.isGroup = isGroup;
        this.content = text;
        this.setRichText(rich);
        this.setSender(senderName);
        this.setSenderId(senderId);
        this.timeStamp = System.currentTimeMillis();
    }

    public ChatMsg(String content, String richText, int chatMsgType, String id) {
        this.content = content;
        this.setRichText(richText);
        this.chatMsgType = chatMsgType;
        this.id = id;
        this.timeStamp = System.currentTimeMillis();
    }

    public boolean isGroup() {
        return this.isGroup ? this.isGroup : this.chatMsgType == 0;
    }

    public void setGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public String getContent() {
        return this.content == null ? "" : this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void receiveRichText(String richText) {
        this.richText = GenseeConfig.sysChatStyle ? ChatMsg.fixRichText(richText) : richText;
    }

    public String getSendRichText() {
        String sendText = this.sendRichText == null || "".equals(this.sendRichText) ? this.getContent() : this.sendRichText;
        this.sendRichText = null;
        return sendText;
    }

    public String getRichText() {
        return this.richText == null || "".equals(this.richText) ? this.getContent() : this.richText;
    }

    public void setRichText(String richText) {
        this.sendRichText = richText;
        this.receiveRichText(richText);
    }

    public long getReceiverId() {
        return this.receiverId;
    }

    public void setReceiverId(long receiverId) {
        this.receiverId = receiverId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public int getChatId() {
        return this.chatId;
    }

    public void setChatId(int receiverChatId) {
        this.chatId = receiverChatId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String chatMsgId) {
        this.id = chatMsgId;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public int getChatMsgType() {
        return this.chatMsgType == -1 ? (this.isGroup ? 0 : 2) : this.chatMsgType;
    }

    public void setChatMsgType(int chatMsgType) {
        this.chatMsgType = chatMsgType;
    }

    public String getCensorType() {
        return this.censorType;
    }

    public void setCensorType(String censorType) {
        this.censorType = censorType;
    }

    @Override
    protected String getXml() {
        return "";
    }

    public boolean isPubValid() {
        String id = this.getId();
        return !StringUtil.isEmpty(id) && !StringUtil.isEmpty(this.content) && !StringUtil.isEmpty(this.richText) && this.content.length() <= 512;
    }

    public boolean isPriValid() {
        return this.receiverId != 0L && this.isPubValid();
    }

    public boolean isPlayerPriValid() {
        return this.chatId != 0 && this.isPubValid();
    }

    public String getSubClassId() {
        return this.subClassId;
    }

    public void setSubClassId(String subClassId) {
        this.subClassId = subClassId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    protected BaseMsg onXmlNode(Context c, Node n) {
        return this;
    }

    @Override
    public String toString() {
        return "ChatMsg [content=" + this.content + ", richText=" + this.richText + ", receiverId=" + this.receiverId + ", chatId=" + this.chatId + ", chatMsgType=" + this.chatMsgType + ", id=" + this.id + "]";
    }

    public static String fixRichText(String richText) {
        if (richText != null && (richText.startsWith("<SPAN") || richText.startsWith("<span"))) {
            int indexBold;
            int endIndex = richText.indexOf(62);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < richText.length(); ++i) {
                char c = richText.charAt(i);
                if (i > 4 && i < endIndex && c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                sb.append(c);
            }
            richText = sb.toString();
            int indexItalic = richText.indexOf("italic");
            if (indexItalic > 4 && indexItalic < endIndex) {
                richText = "<em>" + richText + "</em>";
            }
            if ((indexBold = richText.indexOf("bold")) > 4 && indexBold < endIndex) {
                richText = "<b>" + richText + "</b>";
            }
        }
        return richText;
    }
}

