/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.db;

import android.content.Context;
import android.content.ContextWrapper;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.os.Environment;
import com.gensee.utils.GenseeLog;
import java.io.File;
import java.io.IOException;

public class DatabaseContext
extends ContextWrapper {
    public DatabaseContext(Context base) {
        super(base);
    }

    public boolean deleteDatabase(String name) {
        boolean sdExist = "mounted".equals(Environment.getExternalStorageState());
        if (!sdExist) {
            GenseeLog.e("deleteDatabase", name + "sdcard not exist");
            return false;
        }
        String dbDir = this.getExternalFilesDir("db").getAbsolutePath();
        String dbPath = dbDir + "/" + name;
        File dbFile = new File(dbPath);
        if (dbFile.exists()) {
            try {
                dbFile.delete();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public File getDatabasePath(String name) {
        boolean sdExist = "mounted".equals(Environment.getExternalStorageState());
        if (!sdExist) {
            GenseeLog.e("getDatabasePath", name + "sdcard not exist");
            return null;
        }
        String dbDir = this.getExternalFilesDir("db").getAbsolutePath();
        String dbPath = dbDir + "/" + name;
        File dirFile = new File(dbDir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        boolean isFileCreateSuccess = false;
        File dbFile = new File(dbPath);
        if (!dbFile.exists()) {
            try {
                isFileCreateSuccess = dbFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            isFileCreateSuccess = true;
        }
        if (isFileCreateSuccess) {
            return dbFile;
        }
        return null;
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        SQLiteDatabase result = SQLiteDatabase.openOrCreateDatabase((File)this.getDatabasePath(name), null);
        return result;
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
        SQLiteDatabase result = SQLiteDatabase.openOrCreateDatabase((File)this.getDatabasePath(name), null);
        return result;
    }
}

