/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.drawable.BitmapDrawable;
import com.gensee.common.GenseeConstant;
import com.gensee.entity.LoginResEntity;
import java.util.UUID;

public class GenseeConfig {
    private static final String KEY_CONFIG_UNIDEVICE_ID = "unideviceid";
    private static final String SP_CONFIG_NAME = "genseeconfig";
    private static final int LIVE_DEVICE_TYPE_DEF = 0;
    public static final int LIVE_DEVICE_TYPE_PHONE = 1;
    public static final int LIVE_DEVICE_TYPE_PAD = 2;
    public static final int LIVE_DEVICE_TYPE_TV = 3;
    public static final int CLASS_TYPE_BIG = 3;
    public static final int CLASS_TYPE_SMALL = 4;
    public static final int CLASS_TYPE_SMALL_MASTER = 5;
    public static final int CLASS_TYPE_SMALL_SLAVE = 6;
    public static final int CLASS_TYPE_MINI = 7;
    private static final String UA_NAME = "GenseeSDK";
    public static int vodCacheCount = 10;
    private static BitmapDrawable arrowDrawable;
    private static String clientAppName;
    public static final long MIN_CUSTOM_USER_ID = 1000000000L;
    public static final String SCHEME_HTTP = "http://";
    public static final String SCHEME_HTTPS = "https://";
    public static boolean isUIDVerification;
    public static boolean isMultiPlayer;
    public static boolean isDocDataPng;
    public static boolean isTls;
    @Deprecated
    public static boolean thirdCertificationAuth;
    public static boolean isNeedChatMsg;
    public static boolean isTV;
    public static boolean isCloseSpeakerDefault;
    public static boolean isTargetVerLessQ;
    public static int viColorSpace;
    public static boolean isPVHardDecode;
    public static String uaName;
    public static String uaVer;
    public static boolean isTwoStep;
    public static boolean isForceFlv;
    public static boolean sysChatStyle;
    private static boolean videoDefaultBackCamera;
    private LoginResEntity loginResEntity;
    private static int deviceType;
    private static String uniDeviceId;
    private static GenseeConfig ins;

    private GenseeConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GenseeConfig getIns() {
        if (ins != null) return ins;
        Class<GenseeConfig> clazz = GenseeConfig.class;
        synchronized (GenseeConfig.class) {
            if (ins != null) return ins;
            ins = new GenseeConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ins;
        }
    }

    public static String getUA() {
        return (uaName == null ? UA_NAME : uaName) + '/' + (uaVer == null ? GenseeConfig.getSDKVersion() : uaVer) + GenseeConstant.GENSEE_USER_AGENT;
    }

    public static String getSDKVersionInfo() {
        return "\n|*****************************|\n|*------  GENSEE SDK   ------*|\n|*-----  Version  " + GenseeConfig.getSDKVersion() + "  ----*|\n|*--GLiveSDK & Rtchatfilter--*|\n|*****************************|\n";
    }

    public static String getSDKVersion() {
        return "3.26.11";
    }

    public static String getAppName() {
        return clientAppName;
    }

    public static void setAppName(String appName) {
        clientAppName = appName;
    }

    public static void initDrawable(Context context, int resId) {
        arrowDrawable = (BitmapDrawable)context.getResources().getDrawable(resId);
    }

    public static BitmapDrawable getArrowDrawable() {
        return arrowDrawable;
    }

    public static String getScheme() {
        return isTls ? SCHEME_HTTPS : SCHEME_HTTP;
    }

    public static int getDeviceType() {
        return deviceType;
    }

    public static void setDeviceType(int deviceType) {
        if (deviceType > 0 && deviceType < 4) {
            GenseeConfig.deviceType = deviceType;
        }
    }

    public static boolean isVideoDefaultBackCamera() {
        return videoDefaultBackCamera;
    }

    public static void setVideoDefaultBackCamera(boolean videoDefaultBackCamera) {
        GenseeConfig.videoDefaultBackCamera = videoDefaultBackCamera;
    }

    public LoginResEntity getLoginResEntity() {
        return this.loginResEntity;
    }

    public void setLoginResEntity(LoginResEntity loginResEntity) {
        this.loginResEntity = loginResEntity;
    }

    public static String getUniDeviceId(Context context) {
        if (uniDeviceId != null) {
            return uniDeviceId;
        }
        SharedPreferences sp = context.getSharedPreferences(SP_CONFIG_NAME, 0);
        uniDeviceId = sp.getString(KEY_CONFIG_UNIDEVICE_ID, "");
        if ("".equals(uniDeviceId)) {
            uniDeviceId = UUID.randomUUID().toString();
            sp.edit().putString(KEY_CONFIG_UNIDEVICE_ID, uniDeviceId).commit();
        }
        return uniDeviceId;
    }

    public void clean() {
        this.loginResEntity = null;
    }

    public static String getConfId(LoginResEntity entity) {
        if (null == entity) {
            return null;
        }
        int runStatus = entity.getRunStatus();
        if (runStatus == 1) {
            return entity.getMasterRoomId();
        }
        return entity.getWebcastId();
    }

    static {
        isUIDVerification = true;
        isMultiPlayer = false;
        isDocDataPng = false;
        isTls = false;
        thirdCertificationAuth = true;
        isNeedChatMsg = true;
        isTV = false;
        isCloseSpeakerDefault = false;
        isTargetVerLessQ = false;
        viColorSpace = 1;
        isPVHardDecode = false;
        uaName = UA_NAME;
        isTwoStep = false;
        isForceFlv = false;
        sysChatStyle = false;
        videoDefaultBackCamera = false;
        deviceType = 0;
    }
}

