/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.chatfilter;

import android.text.TextUtils;
import com.gensee.chatfilter.IGSTextFilter;
import com.gensee.chatfilter.OnGSTextFilterListener;
import com.gensee.net.AbsHttpAction;
import com.gensee.net.StringRes;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.ThreadPool;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteFilter
extends AbsHttpAction
implements IGSTextFilter {
    private String TAG = "RemoteFilter";
    private String filterUrl = "http://192.168.1.164:9093";
    private final String METHED_PATH = "/wordfilter/query?siteid=%d&text=%s&confid=%s";
    private int siteId = 0;
    private String confid = "";

    public RemoteFilter(String filterUrl, int siteId, String confid) {
        super(null);
        this.filterUrl = filterUrl;
        this.setSiteId(siteId);
        this.confid = confid;
        GenseeLog.d(this.TAG, "RemoteFilter oncreate " + this);
    }

    public void setFilterUrl(String url) {
        this.filterUrl = url;
    }

    public void setSiteId(int siteId) {
        this.siteId = siteId;
    }

    @Override
    public String textFilter(final String content, final OnGSTextFilterListener listerner) {
        GenseeLog.d(this.TAG, "start filter text: " + content);
        ThreadPool.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                block2: {
                    String url = null;
                    try {
                        url = RemoteFilter.this.filterUrl + String.format("/wordfilter/query?siteid=%d&text=%s&confid=%s", RemoteFilter.this.siteId, URLEncoder.encode(content, "UTF-8"), RemoteFilter.this.confid);
                        RemoteFilter.this.getReq(url, new StringRes(){

                            @Override
                            public void onRes(String result) {
                                block7: {
                                    if (!TextUtils.isEmpty((CharSequence)result)) {
                                        try {
                                            JSONObject jsonObject = new JSONObject(result);
                                            int rc = jsonObject.optInt("rc");
                                            String msg = jsonObject.optString("msg");
                                            if (rc == 0) {
                                                String text = jsonObject.optString("text");
                                                GenseeLog.d(RemoteFilter.this.TAG, "filter success,new text is: " + text + ",orgin text is " + content);
                                                if (listerner != null) {
                                                    listerner.onTextFilter(text);
                                                }
                                            } else {
                                                GenseeLog.e(RemoteFilter.this.TAG, "filter failed,response msg is: " + msg + ",orgin text is " + content);
                                                if (listerner != null) {
                                                    listerner.onTextFilter(content);
                                                }
                                            }
                                        }
                                        catch (JSONException e) {
                                            e.printStackTrace();
                                            GenseeLog.e(RemoteFilter.this.TAG, "filter failed,exception msg is: " + e.getMessage() + ",orgin text is " + content);
                                            if (listerner == null) break block7;
                                            listerner.onTextFilter(content);
                                        }
                                    }
                                }
                            }

                            @Override
                            public void onConnectError(int errorType, String errorInfo) {
                                GenseeLog.e(RemoteFilter.this.TAG, "filter failed,onConnectError msg is: " + errorInfo + ",orgin text is " + content);
                                if (listerner != null) {
                                    listerner.onTextFilter(content);
                                }
                            }
                        });
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                        GenseeLog.e(RemoteFilter.this.TAG, "filter failed,exception msg is: " + e.getMessage() + ",orgin text is " + content);
                        if (listerner == null) break block2;
                        listerner.onTextFilter(content);
                    }
                }
            }
        });
        return null;
    }
}

