/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.canvasgl.textureFilter;

import android.opengl.GLES20;
import com.gensee.canvasgl.ICanvasGL;
import com.gensee.canvasgl.OpenGLUtil;
import com.gensee.canvasgl.glcanvas.BasicTexture;
import com.gensee.canvasgl.textureFilter.BasicTextureFilter;
import com.gensee.canvasgl.textureFilter.OneValueFilter;

public class SaturationFilter
extends BasicTextureFilter
implements OneValueFilter {
    public static final String UNIFORM_SATURATION = "saturation";
    public static final String SATURATION_FRAGMENT_SHADER = "precision mediump float;\n varying vec2 vTextureCoord;\n \n uniform sampler2D uTextureSampler;\n uniform float uAlpha;\n uniform float saturation;\n \n // Values from \"Graphics Shaders: Theory and Practice\" by Bailey and Cunningham\n const vec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);\n \n void main() {\n     vec4 textureColor = texture2D(uTextureSampler, vTextureCoord);\n    float luminance = dot(textureColor.rgb, luminanceWeighting);\n    vec3 greyScaleColor = vec3(luminance);\n    \n    gl_FragColor = vec4(mix(greyScaleColor, textureColor.rgb, saturation), textureColor.w);\n    gl_FragColor *= uAlpha;\n }";
    private float mSaturation;
    private int mSaturationLocation;

    public SaturationFilter(float mSaturation) {
        this.mSaturation = mSaturation;
    }

    @Override
    public String getFragmentShader() {
        return SATURATION_FRAGMENT_SHADER;
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
        super.onPreDraw(program, texture, canvas);
        this.mSaturationLocation = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_SATURATION);
        OpenGLUtil.setFloat(this.mSaturationLocation, this.mSaturation);
    }

    @Override
    public void setValue(float saturation) {
        this.mSaturation = saturation;
    }
}

