/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.canvasgl.textureFilter;

import com.gensee.canvasgl.glcanvas.BasicTexture;
import com.gensee.canvasgl.glcanvas.GLCanvas;
import com.gensee.canvasgl.glcanvas.RawTexture;
import com.gensee.canvasgl.textureFilter.BasicTextureFilter;
import com.gensee.canvasgl.textureFilter.TextureFilter;
import java.util.ArrayList;
import java.util.List;

public class FilterGroup
extends BasicTextureFilter {
    private static final String TAG = "FilterGroup";
    protected List<TextureFilter> mFilters;
    protected List<TextureFilter> mMergedFilters;
    private final List<RawTexture> rawTextureList = new ArrayList<RawTexture>();
    private BasicTexture outputTexture;
    private BasicTexture initialTexture;

    public FilterGroup(List<TextureFilter> mFilters) {
        this.mFilters = mFilters;
        this.updateMergedFilters();
    }

    private void createTextures(BasicTexture initialTexture) {
        this.recycleTextures();
        for (int i = 0; i < this.mMergedFilters.size(); ++i) {
            this.rawTextureList.add(new RawTexture(initialTexture.getWidth(), initialTexture.getHeight(), false));
        }
    }

    private void recycleTextures() {
        for (RawTexture rawTexture : this.rawTextureList) {
            rawTexture.recycle();
        }
        this.rawTextureList.clear();
    }

    public BasicTexture draw(BasicTexture initialTexture, GLCanvas glCanvas, OnDrawListener onDrawListener) {
        if (initialTexture instanceof RawTexture ? !((RawTexture)initialTexture).isNeedInvalidate() : this.initialTexture == initialTexture && this.outputTexture != null) {
            return this.outputTexture;
        }
        if (this.rawTextureList.size() != this.mMergedFilters.size() || this.initialTexture != initialTexture) {
            this.createTextures(initialTexture);
        }
        this.initialTexture = initialTexture;
        BasicTexture drawTexture = initialTexture;
        int size = this.rawTextureList.size();
        for (int i = 0; i < size; ++i) {
            RawTexture rawTexture = this.rawTextureList.get(i);
            TextureFilter textureFilter = this.mMergedFilters.get(i);
            glCanvas.beginRenderTarget(rawTexture);
            onDrawListener.onDraw(drawTexture, textureFilter, i == 0);
            glCanvas.endRenderTarget();
            drawTexture = rawTexture;
        }
        this.outputTexture = drawTexture;
        return drawTexture;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.recycleTextures();
    }

    public List<TextureFilter> getMergedFilters() {
        return this.mMergedFilters;
    }

    public void updateMergedFilters() {
        if (this.mFilters == null) {
            return;
        }
        if (this.mMergedFilters == null) {
            this.mMergedFilters = new ArrayList<TextureFilter>();
        } else {
            this.mMergedFilters.clear();
        }
        for (TextureFilter filter : this.mFilters) {
            if (filter instanceof FilterGroup) {
                ((FilterGroup)filter).updateMergedFilters();
                List<TextureFilter> filters = ((FilterGroup)filter).getMergedFilters();
                if (filters == null || filters.isEmpty()) continue;
                this.mMergedFilters.addAll(filters);
                continue;
            }
            this.mMergedFilters.add(filter);
        }
    }

    public static interface OnDrawListener {
        public void onDraw(BasicTexture var1, TextureFilter var2, boolean var3);
    }
}

