/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.canvasgl.textureFilter;

import android.opengl.GLES20;
import com.gensee.canvasgl.ICanvasGL;
import com.gensee.canvasgl.OpenGLUtil;
import com.gensee.canvasgl.glcanvas.BasicTexture;
import com.gensee.canvasgl.textureFilter.BasicTextureFilter;
import com.gensee.canvasgl.textureFilter.OneValueFilter;

public class ContrastFilter
extends BasicTextureFilter
implements OneValueFilter {
    public static final String UNIFORM_CONTRAST = "contrast";
    public static final String CONTRAST_FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform float contrast;\nuniform sampler2D uTextureSampler;\nvoid main() {\n  vec4 textureColor = texture2D(uTextureSampler, vTextureCoord);\n  gl_FragColor = vec4(((textureColor.rgb - vec3(0.5)) * contrast+ vec3(0.5)), textureColor.w);\n  gl_FragColor *= uAlpha;\n}\n";
    private float mContrast;

    public ContrastFilter(float contrast) {
        this.mContrast = contrast;
    }

    @Override
    public String getFragmentShader() {
        return CONTRAST_FRAGMENT_SHADER;
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
        super.onPreDraw(program, texture, canvas);
        int contrastLocation = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_CONTRAST);
        OpenGLUtil.setFloat(contrastLocation, this.mContrast);
    }

    @Override
    public void setValue(float contrast) {
        this.mContrast = contrast;
    }
}

