/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.canvasgl.textureFilter;

import android.opengl.GLES20;
import com.gensee.canvasgl.ICanvasGL;
import com.gensee.canvasgl.OpenGLUtil;
import com.gensee.canvasgl.glcanvas.BasicTexture;
import com.gensee.canvasgl.textureFilter.BasicTextureFilter;
import com.gensee.canvasgl.textureFilter.OneValueFilter;

public class ColorMatrixFilter
extends BasicTextureFilter
implements OneValueFilter {
    public static final String UNIFORM_COLOR_MATRIX = "colorMatrix";
    public static final String UNIFORM_INTENSITY = "intensity";
    public static final String COLOR_MATRIX_FRAGMENT_SHADER = "precision mediump float; \nvarying highp vec2 vTextureCoord;\n\nuniform sampler2D uTextureSampler;\n\nuniform lowp mat4 colorMatrix;\nuniform lowp float intensity;\n uniform float uAlpha;\n\nvoid main() {\n    lowp vec4 textureColor = texture2D(uTextureSampler, vTextureCoord);\n    lowp vec4 outputColor = textureColor * colorMatrix;\n    \n    gl_FragColor = (intensity * outputColor) + ((1.0 - intensity) * textureColor);\n    gl_FragColor *= uAlpha;\n}";
    private float mIntensity;
    private float[] mColorMatrix;

    public ColorMatrixFilter(float intensity, float[] colorMatrix) {
        this.mIntensity = intensity;
        this.mColorMatrix = colorMatrix;
    }

    public void setIntensity(float intensity) {
        this.mIntensity = intensity;
    }

    public void setColorMatrix(float[] colorMatrix) {
        this.mColorMatrix = colorMatrix;
    }

    @Override
    public String getFragmentShader() {
        return COLOR_MATRIX_FRAGMENT_SHADER;
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
        super.onPreDraw(program, texture, canvas);
        OpenGLUtil.setFloat(GLES20.glGetUniformLocation((int)program, (String)UNIFORM_INTENSITY), this.mIntensity);
        OpenGLUtil.setUniformMatrix4f(GLES20.glGetUniformLocation((int)program, (String)UNIFORM_COLOR_MATRIX), this.mColorMatrix);
    }

    @Override
    public void setValue(float value) {
        this.setIntensity(value);
    }
}

