/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.canvasgl.textureFilter;

import com.gensee.canvasgl.ICanvasGL;
import com.gensee.canvasgl.glcanvas.BasicTexture;
import com.gensee.canvasgl.textureFilter.TextureFilter;

public class BasicTextureFilter
implements TextureFilter {
    public static final String MATRIX_UNIFORM = "uMatrix";
    public static final String TEXTURE_MATRIX_UNIFORM = "uTextureMatrix";
    public static final String POSITION_ATTRIBUTE = "aPosition";
    public static final String VARYING_TEXTURE_COORD = "vTextureCoord";
    public static final String TEXTURE_VERTEX_SHADER = "uniform mat4 uMatrix;\nuniform mat4 uTextureMatrix;\nattribute vec2 aPosition;\nvarying vec2 vTextureCoord;\nvoid main() {\n  vec4 pos = vec4(aPosition, 0.0, 1.0);\n  gl_Position = uMatrix * pos;\n  vTextureCoord = (uTextureMatrix * pos).xy;\n}\n";
    public static final String ALPHA_UNIFORM = "uAlpha";
    public static final String TEXTURE_SAMPLER_UNIFORM = "uTextureSampler";
    public static final String SAMPLER_2D = "sampler2D";
    public static final String TEXTURE_FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform sampler2D uTextureSampler;\nvoid main() {\n  gl_FragColor = texture2D(uTextureSampler, vTextureCoord);\n  gl_FragColor *= uAlpha;\n}\n";
    public static final String SAMPLER_EXTERNAL_OES = "samplerExternalOES";

    @Override
    public String getVertexShader() {
        return TEXTURE_VERTEX_SHADER;
    }

    @Override
    public String getFragmentShader() {
        return TEXTURE_FRAGMENT_SHADER;
    }

    @Override
    public String getOesFragmentProgram() {
        return "#extension GL_OES_EGL_image_external : require\n" + this.getFragmentShader().replace(SAMPLER_2D, SAMPLER_EXTERNAL_OES);
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
    }

    @Override
    public void destroy() {
    }
}

