/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.canvasgl.glcanvas;

import android.graphics.RectF;
import com.gensee.canvasgl.glcanvas.BasicTexture;

public class TextureMatrixTransformer {
    public static void convertCoordinate(RectF source, BasicTexture texture) {
        float yBound;
        int width = texture.getWidth();
        int height = texture.getHeight();
        int texWidth = texture.getTextureWidth();
        int texHeight = texture.getTextureHeight();
        source.left /= (float)texWidth;
        source.right /= (float)texWidth;
        source.top /= (float)texHeight;
        source.bottom /= (float)texHeight;
        float xBound = (float)width / (float)texWidth;
        if (source.right > xBound) {
            source.right = xBound;
        }
        if (source.bottom > (yBound = (float)height / (float)texHeight)) {
            source.bottom = yBound;
        }
    }

    public static void setTextureMatrix(RectF source, float[] textureMatrix) {
        textureMatrix[0] = source.width();
        textureMatrix[5] = source.height();
        textureMatrix[12] = source.left;
        textureMatrix[13] = source.top;
    }

    public static void copyTextureCoordinates(BasicTexture texture, RectF outRect) {
        boolean left = false;
        boolean top = false;
        int right = texture.getWidth();
        int bottom = texture.getHeight();
        if (texture.hasBorder()) {
            left = true;
            top = true;
            --right;
            --bottom;
        }
        outRect.set((float)left, (float)top, (float)right, (float)bottom);
    }
}

