/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.canvasgl;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import com.gensee.canvasgl.glcanvas.BasicTexture;
import com.gensee.canvasgl.glcanvas.BitmapTexture;
import com.gensee.canvasgl.glcanvas.GLCanvas;
import com.gensee.canvasgl.glcanvas.GLES20Canvas;
import com.gensee.canvasgl.glcanvas.GLPaint;
import com.gensee.canvasgl.glcanvas.RawTexture;
import com.gensee.canvasgl.matrix.BaseBitmapMatrix;
import com.gensee.canvasgl.matrix.IBitmapMatrix;
import com.gensee.canvasgl.textureFilter.TextureFilter;

public interface ICanvasGL {
    public BitmapTexture bindBitmapToTexture(int var1, Bitmap var2);

    public void bindRawTexture(int var1, RawTexture var2);

    public void beginRenderTarget(RawTexture var1);

    public void endRenderTarget();

    public GLCanvas getGlCanvas();

    public void drawSurfaceTexture(BasicTexture var1, SurfaceTexture var2, int var3, int var4, int var5, int var6);

    public void drawSurfaceTexture(BasicTexture var1, SurfaceTexture var2, int var3, int var4, int var5, int var6, TextureFilter var7);

    public void drawSurfaceTexture(BasicTexture var1, SurfaceTexture var2, IBitmapMatrix var3);

    public void drawSurfaceTexture(BasicTexture var1, SurfaceTexture var2, IBitmapMatrix var3, TextureFilter var4);

    public void drawSurfaceTexture(BasicTexture var1, SurfaceTexture var2, int var3, int var4, int var5, int var6, IBitmapMatrix var7, TextureFilter var8);

    public void drawBitmap(Bitmap var1, IBitmapMatrix var2);

    public void drawBitmap(Bitmap var1, IBitmapMatrix var2, TextureFilter var3);

    public void drawBitmap(Bitmap var1, Rect var2, RectF var3);

    public void drawBitmap(Bitmap var1, int var2, int var3);

    public void drawBitmap(Bitmap var1, int var2, int var3, TextureFilter var4);

    public void drawBitmap(Bitmap var1, Rect var2, Rect var3);

    public void drawBitmap(Bitmap var1, RectF var2, RectF var3, TextureFilter var4);

    public void drawBitmap(Bitmap var1, int var2, int var3, int var4, int var5);

    public void drawBitmap(Bitmap var1, int var2, int var3, int var4, int var5, TextureFilter var6);

    public void invalidateTextureContent(Bitmap var1);

    public void drawCircle(float var1, float var2, float var3, GLPaint var4);

    public void drawLine(float var1, float var2, float var3, float var4, GLPaint var5);

    public void drawRect(RectF var1, GLPaint var2);

    public void drawRect(Rect var1, GLPaint var2);

    public void drawRect(float var1, float var2, float var3, float var4, GLPaint var5);

    public void save();

    public void save(int var1);

    public void restore();

    public void rotate(float var1);

    public void rotate(float var1, float var2, float var3);

    public void scale(float var1, float var2);

    public void scale(float var1, float var2, float var3, float var4);

    public void translate(float var1, float var2);

    public void clearBuffer();

    public void clearBuffer(int var1);

    public void setSize(int var1, int var2);

    public int getWidth();

    public int getHeight();

    public void resume();

    public void pause();

    public void setAlpha(int var1);

    public static class OrthoBitmapMatrix
    extends BaseBitmapMatrix {
        public OrthoBitmapMatrix() {
            this.reset();
        }

        public void translate(float dx, float dy) {
            this.transform[0] = this.transform[0] + dx;
            this.transform[1] = this.transform[1] + dy;
        }

        public void scale(float sx, float sy) {
            this.transform[2] = this.transform[2] * sx;
            this.transform[3] = this.transform[3] * sy;
        }

        public void rotateZ(float degrees) {
            this.transform[6] = this.transform[6] + degrees;
        }

        @Override
        public float[] obtainResultMatrix(int viewportW, int viewportH, float x, float y, float drawW, float drawH) {
            float ratio = (float)viewportW / (float)viewportH;
            this.transform[0] = this.transform[0] + x;
            this.transform[1] = this.transform[1] + y;
            GLES20.glViewport((int)0, (int)0, (int)viewportW, (int)viewportH);
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)0.0f, (float)ratio, (float)0.0f, (float)1.0f, (float)-1.0f, (float)1.0f);
            Matrix.multiplyMM((float[])this.viewProjectionMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0, (float[])this.mViewMatrix, (int)0);
            Matrix.scaleM((float[])this.mModelMatrix, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
            GLES20Canvas.printMatrix("model init:", this.mModelMatrix, 0);
            Matrix.rotateM((float[])this.mModelMatrix, (int)0, (float)this.transform[6], (float)0.0f, (float)0.0f, (float)1.0f);
            GLES20Canvas.printMatrix("model rotated:", this.mModelMatrix, 0);
            float transX = this.transform[0] / (float)viewportW;
            float transY = this.transform[1] / (float)viewportH - 1.0f;
            Matrix.translateM((float[])this.tempMultiplyMatrix4, (int)0, (float[])this.mModelMatrix, (int)0, (float)transX, (float)transY, (float)0.0f);
            GLES20Canvas.printMatrix("model translated:", this.tempMultiplyMatrix4, 0);
            Matrix.scaleM((float[])this.tempMultiplyMatrix4, (int)0, (float)(this.transform[2] * drawW / (float)viewportW * ratio), (float)(this.transform[3] * drawH / (float)viewportH), (float)1.0f);
            GLES20Canvas.printMatrix("model scaled:", this.tempMultiplyMatrix4, 0);
            Matrix.multiplyMM((float[])this.mvp, (int)0, (float[])this.viewProjectionMatrix, (int)0, (float[])this.tempMultiplyMatrix4, (int)0);
            GLES20Canvas.printMatrix("ultra matrix:", this.mvp, 0);
            return this.mvp;
        }
    }

    public static class BitmapMatrix
    extends BaseBitmapMatrix {
        private final int maxViewPortInt;

        public BitmapMatrix() {
            this.reset();
            int[] maxViewPort = new int[1];
            GLES20.glGetIntegerv((int)3386, (int[])maxViewPort, (int)0);
            this.maxViewPortInt = maxViewPort[0];
        }

        public void translate(float dx, float dy) {
            this.transform[0] = this.transform[0] + dx;
            this.transform[1] = this.transform[1] + dy;
        }

        public void scale(float sx, float sy) {
            this.transform[2] = this.transform[2] * sx;
            this.transform[3] = this.transform[3] * sy;
        }

        public void rotateX(float degrees) {
            this.transform[4] = this.transform[4] + degrees;
        }

        public void rotateY(float degrees) {
            this.transform[5] = this.transform[5] + degrees;
        }

        public void rotateZ(float degrees) {
            this.transform[6] = this.transform[6] + degrees;
        }

        @Override
        public float[] obtainResultMatrix(int viewportW, int viewportH, float x, float y, float drawW, float drawH) {
            this.transform[0] = this.transform[0] + x;
            this.transform[1] = this.transform[1] + y;
            int viewPortRatio = 2;
            float absTransX = Math.abs(this.transform[0]);
            float absTransY = Math.abs(this.transform[1]);
            int realViewportW = (int)((float)(viewPortRatio * viewportW) + 2.0f * absTransX);
            int realViewportH = (int)((float)(viewPortRatio * viewportH) + 2.0f * absTransY);
            realViewportW = Math.max(realViewportW, this.maxViewPortInt);
            realViewportH = Math.min(realViewportH, this.maxViewPortInt);
            int viewportX = (int)(drawW / 2.0f - (float)(realViewportW / 2) + this.transform[0]);
            int viewportY = (int)(-drawH / 2.0f - this.transform[1] - (float)(realViewportH / 2) + (float)viewportH);
            GLES20.glViewport((int)viewportX, (int)viewportY, (int)realViewportW, (int)realViewportH);
            float ratio = (float)realViewportW / (float)realViewportH;
            Matrix.frustumM((float[])this.mProjectionMatrix, (int)0, (float)(-ratio), (float)ratio, (float)-1.0f, (float)1.0f, (float)1.0f, (float)10.0f);
            Matrix.setLookAtM((float[])this.mViewMatrix, (int)0, (float)0.0f, (float)0.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.multiplyMM((float[])this.viewProjectionMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0, (float[])this.mViewMatrix, (int)0);
            Matrix.scaleM((float[])this.mModelMatrix, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
            GLES20Canvas.printMatrix("model init:", this.mModelMatrix, 0);
            Matrix.rotateM((float[])this.mModelMatrix, (int)0, (float)this.transform[4], (float)1.0f, (float)0.0f, (float)0.0f);
            Matrix.rotateM((float[])this.mModelMatrix, (int)0, (float)this.transform[5], (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.rotateM((float[])this.mModelMatrix, (int)0, (float)this.transform[6], (float)0.0f, (float)0.0f, (float)1.0f);
            GLES20Canvas.printMatrix("model rotated:", this.mModelMatrix, 0);
            float realW = 2.0f * ratio * drawW / (float)realViewportW * 5.5f;
            float realH = 2.0f * drawH / (float)realViewportH * 5.5f;
            Matrix.translateM((float[])this.tempMultiplyMatrix4, (int)0, (float[])this.mModelMatrix, (int)0, (float)(-realW / 2.0f), (float)(-realH / 2.0f), (float)-0.5f);
            GLES20Canvas.printMatrix("model translated:", this.tempMultiplyMatrix4, 0);
            Matrix.scaleM((float[])this.tempMultiplyMatrix4, (int)0, (float)(this.transform[2] * realW), (float)(this.transform[3] * realH), (float)1.0f);
            GLES20Canvas.printMatrix("model scaled:", this.tempMultiplyMatrix4, 0);
            Matrix.multiplyMM((float[])this.mvp, (int)0, (float[])this.viewProjectionMatrix, (int)0, (float[])this.tempMultiplyMatrix4, (int)0);
            GLES20Canvas.printMatrix("ultra matrix:", this.mvp, 0);
            return this.mvp;
        }
    }
}

