/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.GPUImage;

import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;
import android.util.Log;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL10;

public class PixelBuffer {
    private static final String TAG = "PixelBuffer";
    private static final boolean LIST_CONFIGS = false;
    private GLSurfaceView.Renderer renderer;
    private int width;
    private int height;
    private Bitmap bitmap;
    private EGL10 egl10;
    private EGLDisplay eglDisplay;
    private EGLConfig[] eglConfigs;
    private EGLConfig eglConfig;
    private EGLContext eglContext;
    private EGLSurface eglSurface;
    private GL10 gl10;
    private String mThreadOwner;

    public PixelBuffer(int width, int height) {
        this.width = width;
        this.height = height;
        int[] version = new int[2];
        int[] attribList = new int[]{12375, this.width, 12374, this.height, 12344};
        this.egl10 = (EGL10)EGLContext.getEGL();
        this.eglDisplay = this.egl10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        this.egl10.eglInitialize(this.eglDisplay, version);
        this.eglConfig = this.chooseConfig();
        int EGL_CONTEXT_CLIENT_VERSION = 12440;
        int[] attrib_list = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
        this.eglContext = this.egl10.eglCreateContext(this.eglDisplay, this.eglConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
        this.eglSurface = this.egl10.eglCreatePbufferSurface(this.eglDisplay, this.eglConfig, attribList);
        this.egl10.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext);
        this.gl10 = (GL10)this.eglContext.getGL();
        this.mThreadOwner = Thread.currentThread().getName();
    }

    public void setRenderer(GLSurfaceView.Renderer renderer) {
        this.renderer = renderer;
        if (!Thread.currentThread().getName().equals(this.mThreadOwner)) {
            Log.e((String)TAG, (String)"setRenderer: This thread does not own the OpenGL context.");
            return;
        }
        this.renderer.onSurfaceCreated(this.gl10, this.eglConfig);
        this.renderer.onSurfaceChanged(this.gl10, this.width, this.height);
    }

    public Bitmap getBitmap() {
        if (this.renderer == null) {
            Log.e((String)TAG, (String)"getBitmap: Renderer was not set.");
            return null;
        }
        if (!Thread.currentThread().getName().equals(this.mThreadOwner)) {
            Log.e((String)TAG, (String)"getBitmap: This thread does not own the OpenGL context.");
            return null;
        }
        this.renderer.onDrawFrame(this.gl10);
        this.renderer.onDrawFrame(this.gl10);
        this.convertToBitmap();
        return this.bitmap;
    }

    public void destroy() {
        this.renderer.onDrawFrame(this.gl10);
        this.renderer.onDrawFrame(this.gl10);
        this.egl10.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        this.egl10.eglDestroySurface(this.eglDisplay, this.eglSurface);
        this.egl10.eglDestroyContext(this.eglDisplay, this.eglContext);
        this.egl10.eglTerminate(this.eglDisplay);
    }

    private EGLConfig chooseConfig() {
        int[] attribList = new int[]{12325, 0, 12326, 0, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344};
        int[] numConfig = new int[1];
        this.egl10.eglChooseConfig(this.eglDisplay, attribList, null, 0, numConfig);
        int configSize = numConfig[0];
        this.eglConfigs = new EGLConfig[configSize];
        this.egl10.eglChooseConfig(this.eglDisplay, attribList, this.eglConfigs, configSize, numConfig);
        return this.eglConfigs[0];
    }

    private void listConfig() {
        Log.i((String)TAG, (String)"Config List {");
        for (EGLConfig config : this.eglConfigs) {
            int d = this.getConfigAttrib(config, 12325);
            int s = this.getConfigAttrib(config, 12326);
            int r = this.getConfigAttrib(config, 12324);
            int g = this.getConfigAttrib(config, 12323);
            int b = this.getConfigAttrib(config, 12322);
            int a = this.getConfigAttrib(config, 12321);
            Log.i((String)TAG, (String)("    <d,s,r,g,b,a> = <" + d + "," + s + "," + r + "," + g + "," + b + "," + a + ">"));
        }
        Log.i((String)TAG, (String)"}");
    }

    private int getConfigAttrib(EGLConfig config, int attribute) {
        int[] value = new int[1];
        return this.egl10.eglGetConfigAttrib(this.eglDisplay, config, attribute, value) ? value[0] : 0;
    }

    private void convertToBitmap() {
        this.bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        throw new RuntimeException("convertToBitmap is never use, so we did not implement yet!");
    }
}

