/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.service;

import com.gensee.callback.IHongbaoCallBack;
import com.gensee.common.GenseeConfig;
import com.gensee.entity.LoginResEntity;
import com.gensee.entity.RewardResult;
import com.gensee.hongbao.GrabInfo;
import com.gensee.hongbao.HongbaoInfo;
import com.gensee.hongbao.UserGrabInfo;
import com.gensee.net.AbsHandler;
import com.gensee.net.AbsHttpAction;
import com.gensee.net.StringRes;
import com.gensee.service.IRedEnvelopes;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class RedEnvelopes
extends AbsHttpAction
implements IRedEnvelopes {
    private static final String TAG = "RedEnvelopes";
    private LoginResEntity entity;
    private IHongbaoCallBack callback;

    public void init(LoginResEntity entity) {
        this.entity = entity;
    }

    public RedEnvelopes(IHongbaoCallBack callback) {
        super(null);
        this.callback = callback;
    }

    public void queryBalance() {
        if (this.entity == null) {
            GenseeLog.w((String)TAG, (String)"queryBalance error not register");
            return;
        }
        String queryBalanceAddr = String.format(Locale.ENGLISH, "%s/getConfBalance?siteid=%d&confid=%s&servicetype=%s&alb=%s", this.entity.getRedPacketApi(), this.entity.getSiteId(), this.getConfId(), this.entity.getServicetype(), StringUtil.urlEncode((String)this.entity.getAlbServer()));
        this.sendRequest(queryBalanceAddr, new StringRes(){

            public void onRes(String result) {
                GenseeLog.d((String)RedEnvelopes.TAG, (String)("queryBalance " + result));
                int ret = -1;
                int balance = 0;
                JSONObject object = AbsHandler.converToJson((String)result);
                if (object != null) {
                    ret = AbsHandler.getJsonInt((JSONObject)object, (String)"rc");
                    JSONObject response = AbsHandler.getJSONObj((JSONObject)object, (String)"response");
                    if (response != null) {
                        balance = AbsHandler.getJsonInt((JSONObject)response, (String)"balance");
                    }
                }
                RedEnvelopes.this.queryBalanceRes(ret == 0, balance);
            }

            public void onConnectError(int errorType, String errorInfo) {
                RedEnvelopes.this.queryBalanceRes(false, 0);
            }
        });
    }

    private void queryBalanceRes(boolean ret, int balance) {
        IHongbaoCallBack callBack = this.callback;
        if (callBack != null) {
            callBack.onHongbaoQueryBalance(ret, balance);
        }
    }

    public String createRandomHongbao(int hongBaoMoney, int hongbaoCount, int timeLimit, boolean isFixed, String comment) {
        if (this.entity == null) {
            GenseeLog.w((String)TAG, (String)"createRandomHongbao error not register");
            return "";
        }
        String strID = this.getHongbaoId();
        String createRandomAddr = String.format(Locale.ENGLISH, "%s/createHongbao?id=%s&siteid=%d&confid=%s&servicetype=%s&alb=%s&userid=%d&username=%s&sum=%d&count=%d&type=%d&timelimit=%d", this.entity.getRedPacketApi(), strID, this.entity.getSiteId(), this.getConfId(), this.entity.getServicetype(), StringUtil.urlEncode((String)this.entity.getAlbServer()), this.entity.getUserId(), StringUtil.urlEncode((String)this.entity.getNickName()), hongBaoMoney, hongbaoCount, isFixed ? 1 : 0, timeLimit);
        if (!StringUtil.isEmpty((String)comment)) {
            createRandomAddr = createRandomAddr + "&comment=" + StringUtil.urlEncode((String)comment);
        }
        this.sendRequest(createRandomAddr, new StringRes(){

            public void onRes(String result) {
                GenseeLog.d((String)RedEnvelopes.TAG, (String)("createRandomHongbao " + result));
                RedEnvelopes.this.hongbaoCreateRes(result);
            }

            public void onConnectError(int errorType, String errorInfo) {
                GenseeLog.w((String)RedEnvelopes.TAG, (String)("createRandomHongbao errorType = " + errorType));
                RedEnvelopes.this.hongbaoCreateCallback(errorType, "");
            }
        });
        return strID;
    }

    public String createHongbaoForSomeBody(int hongBaoMoney, int timeLimit, long receiveUserId, String receiveUserName, String comment) {
        if (this.entity == null) {
            GenseeLog.w((String)TAG, (String)"createHongbaoForSomeBody error not register");
            return "";
        }
        String strID = this.getHongbaoId();
        String createToSomeBody = String.format(Locale.ENGLISH, "%s/createHongbao?id=%s&siteid=%d&confid=%s&servicetype=%s&alb=%s&userid=%d&username=%s&sum=%d&count=1&type=%d&timelimit=%d&touserid=%d&tousername=%s", this.entity.getRedPacketApi(), strID, this.entity.getSiteId(), this.getConfId(), this.entity.getServicetype(), StringUtil.urlEncode((String)this.entity.getAlbServer()), this.entity.getUserId(), StringUtil.urlEncode((String)this.entity.getNickName()), hongBaoMoney, timeLimit == 0 ? 3 : 2, timeLimit, receiveUserId, StringUtil.urlEncode((String)receiveUserName));
        if (!StringUtil.isEmpty((String)comment)) {
            createToSomeBody = createToSomeBody + "&comment=" + StringUtil.urlEncode((String)comment);
        }
        this.sendRequest(createToSomeBody, new StringRes(){

            public void onRes(String result) {
                GenseeLog.d((String)RedEnvelopes.TAG, (String)("createHongbaoForSomeBody " + result));
                RedEnvelopes.this.hongbaoCreateRes(result);
            }

            public void onConnectError(int errorType, String errorInfo) {
                GenseeLog.w((String)RedEnvelopes.TAG, (String)("createHongbaoForSomeBody errorType = " + errorType));
                RedEnvelopes.this.hongbaoCreateCallback(errorType, "");
            }
        });
        return strID;
    }

    private void hongbaoCreateRes(String result) {
        int ret = -1;
        String id = "";
        JSONObject object = AbsHandler.converToJson((String)result);
        if (object != null) {
            ret = AbsHandler.getJsonInt((JSONObject)object, (String)"rc");
            JSONObject response = AbsHandler.getJSONObj((JSONObject)object, (String)"response");
            if (response != null) {
                id = AbsHandler.getJsonString((JSONObject)response, (String)"id");
            }
        }
        this.hongbaoCreateCallback(ret, id);
    }

    private void hongbaoCreateCallback(int ret, String hongbaoId) {
        IHongbaoCallBack callBack = this.callback;
        if (callBack != null) {
            callBack.onHongbaoCreate(ret, hongbaoId);
        }
    }

    public void grabHongbao(final String strHongbaoID) {
        if (this.entity == null) {
            GenseeLog.w((String)TAG, (String)"grabHongbao error not register");
            return;
        }
        String api = this.entity.getRedPacketApi();
        String grab = String.format(Locale.ENGLISH, "%s/grabHongbao?hongbaoid=%s&userid=%d&username=%s", api, strHongbaoID, this.entity.getUserId(), StringUtil.urlEncode((String)this.entity.getNickName()));
        this.sendRequest(grab, new StringRes(){

            public void onRes(String result) {
                int ret = -1;
                int amount = 0;
                JSONObject object = AbsHandler.converToJson((String)result);
                if (object != null) {
                    ret = AbsHandler.getJsonInt((JSONObject)object, (String)"rc");
                    JSONObject response = AbsHandler.getJSONObj((JSONObject)object, (String)"response");
                    if (response != null) {
                        amount = AbsHandler.getJsonInt((JSONObject)response, (String)"amount");
                    }
                }
                RedEnvelopes.this.hongbaoGrabRes(ret, strHongbaoID, amount);
            }

            public void onConnectError(int errorType, String errorInfo) {
                GenseeLog.w((String)RedEnvelopes.TAG, (String)("grabHongbao errorType = " + errorType));
                RedEnvelopes.this.hongbaoGrabRes(errorType, strHongbaoID, 0);
            }
        });
    }

    private void hongbaoGrabRes(int result, String id, int money) {
        IHongbaoCallBack callBack = this.callback;
        if (callBack != null) {
            callBack.onHongbaoGrabHongbao(result, id, money);
        }
    }

    public void queryHongbaoGrabList(final String hongbaoId) {
        if (this.entity == null) {
            GenseeLog.w((String)TAG, (String)"queryHongbaoGrabList error not register");
            return;
        }
        String queryGrabList = String.format("%s/getHongbaoGrabLog?hongbaoid=%s", this.entity.getRedPacketApi(), hongbaoId);
        this.sendRequest(queryGrabList, new StringRes(){

            public void onRes(String result) {
                int size;
                GrabInfo[] grabs = null;
                JSONObject object = AbsHandler.converToJson((String)result);
                JSONArray response = AbsHandler.getArray((JSONObject)object, (String)"response");
                if (response != null && (size = response.length()) >= 0) {
                    grabs = new GrabInfo[size];
                    for (int i = 0; i < size; ++i) {
                        JSONObject grabObject = AbsHandler.getJSONObj((JSONArray)response, (int)i);
                        if (grabObject == null) continue;
                        GrabInfo info = new GrabInfo();
                        info.setGrabTime(AbsHandler.getJsonInt((JSONObject)grabObject, (String)"time"));
                        info.setMoney(AbsHandler.getJsonInt((JSONObject)grabObject, (String)"amount"));
                        info.setUserName(AbsHandler.getJsonString((JSONObject)grabObject, (String)"username"));
                        info.setUserId(AbsHandler.getJsonLong((JSONObject)grabObject, (String)"userid"));
                        info.setBest(AbsHandler.getJsonBool((JSONObject)grabObject, (String)"best"));
                        grabs[i] = info;
                    }
                }
                RedEnvelopes.this.queryHongbaoGrabListCallback(hongbaoId, grabs);
            }

            public void onConnectError(int errorType, String errorInfo) {
                GenseeLog.w((String)RedEnvelopes.TAG, (String)("queryHongbaoGrabList errorType = " + errorType));
                RedEnvelopes.this.queryHongbaoGrabListCallback(hongbaoId, null);
            }
        });
    }

    private void queryHongbaoGrabListCallback(String id, GrabInfo[] grabs) {
        IHongbaoCallBack callBack = this.callback;
        if (callBack != null) {
            callBack.onHongbaoQueryHongbaoGrabList(id, grabs);
        }
    }

    public void queryHongbaoList() {
        if (this.entity == null) {
            GenseeLog.w((String)TAG, (String)"queryHongbaoList error not register");
            return;
        }
        String queryHongbaoList = String.format(Locale.ENGLISH, "%s/getHongbaoList?siteid=%d&confid=%s&servicetype=%s&alb=%s", this.entity.getRedPacketApi(), this.entity.getSiteId(), this.getConfId(), this.entity.getServicetype(), StringUtil.urlEncode((String)this.entity.getAlbServer()));
        this.sendRequest(queryHongbaoList, new StringRes(){

            public void onRes(String result) {
                int size;
                HongbaoInfo[] infos = null;
                JSONObject object = AbsHandler.converToJson((String)result);
                JSONArray array = AbsHandler.getArray((JSONObject)object, (String)"response");
                if (array != null && (size = array.length()) >= 0) {
                    infos = new HongbaoInfo[size];
                    for (int i = 0; i < size; ++i) {
                        JSONObject infoObj = AbsHandler.getJSONObj((JSONArray)array, (int)i);
                        if (infoObj == null) continue;
                        HongbaoInfo info = new HongbaoInfo();
                        info.setCount(AbsHandler.getJsonInt((JSONObject)infoObj, (String)"count"));
                        info.setCreatetime(AbsHandler.getJsonInt((JSONObject)infoObj, (String)"ctime"));
                        info.setToUserName(AbsHandler.getJsonString((JSONObject)infoObj, (String)"tousername"));
                        info.setToUser(AbsHandler.getJsonLong((JSONObject)infoObj, (String)"touserid"));
                        info.setTimeLimit(AbsHandler.getJsonInt((JSONObject)infoObj, (String)"timelimit"));
                        info.setType(AbsHandler.getJsonInt((JSONObject)infoObj, (String)"type"));
                        info.setUserName(AbsHandler.getJsonString((JSONObject)infoObj, (String)"username"));
                        info.setUserId(AbsHandler.getJsonLong((JSONObject)infoObj, (String)"userid"));
                        info.setHongbaoId(AbsHandler.getJsonString((JSONObject)infoObj, (String)"id"));
                        info.setComment(AbsHandler.getJsonString((JSONObject)infoObj, (String)"comment"));
                        info.setLeftCount(AbsHandler.getJsonInt((JSONObject)infoObj, (String)"countleft"));
                        info.setLeftMoney(AbsHandler.getJsonInt((JSONObject)infoObj, (String)"balance"));
                        info.setMoneySum(AbsHandler.getJsonInt((JSONObject)infoObj, (String)"sum"));
                        info.setState(AbsHandler.getJsonInt((JSONObject)infoObj, (String)"state"));
                        infos[i] = info;
                    }
                }
                this.hongbaoQueryList(infos);
            }

            public void onConnectError(int errorType, String errorInfo) {
                GenseeLog.w((String)RedEnvelopes.TAG, (String)("queryHongbaoList errorType = " + errorType));
                this.hongbaoQueryList(null);
            }

            private void hongbaoQueryList(HongbaoInfo[] infos) {
                IHongbaoCallBack callBack = RedEnvelopes.this.callback;
                if (callBack != null) {
                    callBack.onHongbaoQueryHongbaoList(infos);
                }
            }
        });
    }

    public void querySelfGrabList() {
        if (this.entity == null) {
            GenseeLog.w((String)TAG, (String)"querySelfGrabList error not register");
            return;
        }
        String userGrablog = String.format(Locale.ENGLISH, "%s/getUserGrabLog?userid=%d&siteid=%d&confid=%s&servicetype=%s&alb=%s", this.entity.getRedPacketApi(), this.entity.getUserId(), this.entity.getSiteId(), this.getConfId(), this.entity.getServicetype(), StringUtil.urlEncode((String)this.entity.getAlbServer()));
        this.sendRequest(userGrablog, new StringRes(){

            public void onRes(String result) {
                int size;
                JSONObject object = AbsHandler.converToJson((String)result);
                JSONArray array = AbsHandler.getArray((JSONObject)object, (String)"response");
                UserGrabInfo[] infos = null;
                if (array != null && (size = array.length()) >= 0) {
                    infos = new UserGrabInfo[size];
                    for (int i = 0; i < size; ++i) {
                        JSONObject infoObj = AbsHandler.getJSONObj((JSONArray)array, (int)i);
                        if (infoObj == null) continue;
                        UserGrabInfo info = new UserGrabInfo();
                        info.setBest(AbsHandler.getJsonBool((JSONObject)infoObj, (String)"best"));
                        info.setGrabTime(AbsHandler.getJsonInt((JSONObject)infoObj, (String)"time"));
                        info.setHongbaoId(AbsHandler.getJsonString((JSONObject)infoObj, (String)"hongbaoid"));
                        info.setMoney(AbsHandler.getJsonInt((JSONObject)infoObj, (String)"amount"));
                        info.setUserId(AbsHandler.getJsonLong((JSONObject)infoObj, (String)"suserid"));
                        info.setUserName(AbsHandler.getJsonString((JSONObject)infoObj, (String)"susername"));
                        infos[i] = info;
                    }
                } else {
                    GenseeLog.w((String)RedEnvelopes.TAG, (String)("querySelfGrabList " + result));
                }
                this.hongbaoQuerySelfGrabListCallback(infos);
            }

            public void onConnectError(int errorType, String errorInfo) {
                GenseeLog.w((String)RedEnvelopes.TAG, (String)("querySelfGrabList errorType = " + errorType));
                this.hongbaoQuerySelfGrabListCallback(null);
            }

            private void hongbaoQuerySelfGrabListCallback(UserGrabInfo[] infos) {
                IHongbaoCallBack callBack = RedEnvelopes.this.callback;
                if (callBack != null) {
                    callBack.onHongbaoQuerySelfGrabList(infos);
                }
            }
        });
    }

    private void sendRequest(String addr, StringRes res) {
        this.doGetRequest(addr, res);
    }

    private String getHongbaoId() {
        return String.valueOf(System.currentTimeMillis()) + this.entity.getSiteId() + this.entity.getUserId();
    }

    public void notify(RewardResult result) {
        IHongbaoCallBack callBack = this.callback;
        if (callBack != null) {
            if ("create".equals(result.getStep())) {
                HongbaoInfo hongbaoInfo = new HongbaoInfo();
                hongbaoInfo.setComment(result.getComment());
                hongbaoInfo.setHongbaoId(result.getId());
                hongbaoInfo.setUserId(result.getUserId());
                hongbaoInfo.setUserName(result.getName());
                hongbaoInfo.setType((int)result.getHongbaoType());
                hongbaoInfo.setTimeLimit(result.getDuration());
                hongbaoInfo.setToUser(result.getReceiverId());
                hongbaoInfo.setToUserName(result.getReceiver());
                hongbaoInfo.setCreatetime((int)result.getTime());
                callBack.onHongbaoComingNotify(hongbaoInfo);
            } else if ("grab".equals(result.getStep())) {
                GrabInfo grabInfo = new GrabInfo();
                grabInfo.setUserId(result.getUserId());
                grabInfo.setUserName(result.getName());
                grabInfo.setMoney((int)result.getAmount());
                grabInfo.setGrabTime((int)result.getTime());
                callBack.onHongbaoGrabbedNotify(result.getId(), grabInfo, (int)result.getHongbaoType());
            }
        }
    }

    private String getConfId() {
        return GenseeConfig.getConfId((LoginResEntity)this.entity);
    }
}

