/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.service;

import android.text.TextUtils;
import com.gensee.callback.IMedalPraiseCallback;
import com.gensee.common.GenseeConfig;
import com.gensee.entity.LoginResEntity;
import com.gensee.entity.MedalPraiseResult;
import com.gensee.net.AbsHandler;
import com.gensee.net.AbsHttpAction;
import com.gensee.net.StringRes;
import com.gensee.parse.MedalPraiseParse;
import com.gensee.praise.PraiseInfo;
import com.gensee.praise.PraiseUserInfo;
import com.gensee.service.IMedalPraise;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class MedalPraise
extends AbsHttpAction
implements IMedalPraise {
    private static final String TAG = "MedalPraise";
    private int cusMedal = -1;
    private int cusFavour = -1;
    private IMedalPraiseCallback callback;
    private LoginResEntity entity;

    private MedalPraise() {
        super(null);
    }

    public boolean isPraiseEnable() {
        return null != this.entity && this.entity.isFavourEnable();
    }

    public boolean isMedalEnable() {
        return null != this.entity && this.entity.isMedalEnable();
    }

    public MedalPraise(IMedalPraiseCallback callback) {
        super(null);
        this.callback = callback;
    }

    public MedalPraise(IMedalPraiseCallback callback, int defMedal, int defFavour) {
        super(null);
        this.callback = callback;
        this.cusMedal = defMedal;
        this.cusFavour = defFavour;
    }

    public void init(LoginResEntity entity) {
        GenseeLog.d((String)TAG, (String)("init  cusMedal = " + this.cusMedal + " cusFavour = " + this.cusFavour));
        this.entity = entity;
        if (null != entity && entity.getUserId() != 0L) {
            if (entity.isMedalEnable() && this.cusMedal > -2) {
                this.getPraiseInfo("medal", entity.getUserId());
            }
            if (entity.isFavourEnable() && this.cusFavour > -2) {
                this.getPraiseInfo("favour", entity.getUserId());
            }
        } else {
            GenseeLog.w((String)TAG, (String)"initMedalPraise fail,by not join the room");
        }
    }

    public void notify(String info) {
        if (StringUtil.isEmpty((String)info) || !info.startsWith("<")) {
            GenseeLog.w((String)TAG, (String)"notify other message!");
            return;
        }
        MedalPraiseResult result = new MedalPraiseParse().parseMedalPraiseXml(info);
        if (null != this.callback && result != null) {
            String praiseType = result.getMsgType();
            PraiseUserInfo senderUserInfo = new PraiseUserInfo(result.getUserId(), result.getName(), result.getSenderRemainNum(), result.getSenderSendNum(), result.getSenderRevNum());
            PraiseUserInfo receiverUserInfo = new PraiseUserInfo(result.getReceiveUserId(), result.getReceiver(), result.getReceiverRemainNum(), result.getReceiverSendNum(), result.getReceiverRevNum());
            this.callback.onPraiseNotify(praiseType, false, result.getTime(), senderUserInfo, receiverUserInfo, result.getComment());
        }
    }

    @Override
    public void getPraiseInfo(final String praiseType, long userId) {
        if (this.entity == null) {
            GenseeLog.w((String)TAG, (String)"getPraiseInfo error, entity == null");
            return;
        }
        String address = String.format(Locale.ENGLISH, "%s/getPraiseInfo?siteid=%d&confid=%s&servicetype=%s&alb=%s&praisetype=%s&userid=%d", this.entity.getRedPacketApi(), this.entity.getSiteId(), this.getConfId(), this.entity.getServicetype(), StringUtil.urlEncode((String)this.entity.getAlbServer()), praiseType, userId);
        this.doGetRequest(address, new StringRes(){

            public void onRes(String result) {
                GenseeLog.d((String)MedalPraise.TAG, (String)("getPraiseInfo result:" + result));
                int ret = -1;
                PraiseUserInfo userInfo = null;
                JSONObject object = AbsHandler.converToJson((String)result);
                if (object != null) {
                    ret = AbsHandler.getJsonInt((JSONObject)object, (String)"rc");
                    if (ret == 10304) {
                        MedalPraise.this.setPraiseInfo(praiseType, TextUtils.equals((CharSequence)praiseType, (CharSequence)"medal") ? MedalPraise.this.cusMedal : MedalPraise.this.cusFavour);
                        return;
                    }
                    JSONObject response = AbsHandler.getJSONObj((JSONObject)object, (String)"response");
                    if (response != null) {
                        long userId = AbsHandler.getJsonLong((JSONObject)response, (String)"userid");
                        String username = AbsHandler.getJsonString((JSONObject)response, (String)"username");
                        int remain = AbsHandler.getJsonInt((JSONObject)response, (String)"remain");
                        int send = AbsHandler.getJsonInt((JSONObject)response, (String)"send");
                        int recv = AbsHandler.getJsonInt((JSONObject)response, (String)"recv");
                        userInfo = new PraiseUserInfo(userId, username, remain, send, recv);
                    }
                }
                if (null != MedalPraise.this.callback) {
                    MedalPraise.this.callback.onPraiseInfo(ret, praiseType, userInfo);
                }
            }

            public void onConnectError(int errorType, String errorInfo) {
                if (null != MedalPraise.this.callback) {
                    MedalPraise.this.callback.onPraiseInfo(errorType, praiseType, null);
                }
            }
        });
    }

    @Override
    public boolean setPraiseInfo(final String praiseType, int total) {
        if (this.entity == null) {
            GenseeLog.w((String)TAG, (String)"setPraiseInfo error, entity == null");
            return false;
        }
        String address = String.format(Locale.ENGLISH, "%s/setPraiseInfo?siteid=%d&confid=%s&servicetype=%s&alb=%s&praisetype=%s&userid=%d&username=%s&total=%d", this.entity.getRedPacketApi(), this.entity.getSiteId(), this.getConfId(), this.entity.getServicetype(), StringUtil.urlEncode((String)this.entity.getAlbServer()), praiseType, this.entity.getUserId(), this.entity.getNickName(), total);
        this.doGetRequest(address, new StringRes(){

            public void onRes(String result) {
                GenseeLog.d((String)MedalPraise.TAG, (String)("setPraiseInfo result:" + result));
                int ret = -1;
                PraiseUserInfo userInfo = null;
                JSONObject object = AbsHandler.converToJson((String)result);
                if (object != null) {
                    ret = AbsHandler.getJsonInt((JSONObject)object, (String)"rc");
                    JSONObject response = AbsHandler.getJSONObj((JSONObject)object, (String)"response");
                    if (response != null) {
                        long userId = AbsHandler.getJsonLong((JSONObject)response, (String)"userid");
                        String username = AbsHandler.getJsonString((JSONObject)response, (String)"username");
                        int remain = AbsHandler.getJsonInt((JSONObject)response, (String)"remain");
                        int send = AbsHandler.getJsonInt((JSONObject)response, (String)"send");
                        int recv = AbsHandler.getJsonInt((JSONObject)response, (String)"recv");
                        userInfo = new PraiseUserInfo(userId, username, remain, send, recv);
                    }
                }
                if (MedalPraise.this.callback != null) {
                    MedalPraise.this.callback.onPraiseInfo(ret, praiseType, userInfo);
                }
            }

            public void onConnectError(int errorType, String errorInfo) {
                if (MedalPraise.this.callback != null) {
                    MedalPraise.this.callback.onPraiseInfo(errorType, praiseType, null);
                }
            }
        });
        return false;
    }

    @Override
    public boolean sendPraise(final String praiseType, long toUserId, String toUserName, String comment) {
        if (this.entity == null) {
            GenseeLog.w((String)TAG, (String)"sendPraise error, entity == null");
            return false;
        }
        String address = String.format(Locale.ENGLISH, "%s/sendPraise?siteid=%d&confid=%s&servicetype=%s&alb=%s&praisetype=%s&userid=%d&username=%s&touserid=%d&tousername=%s&comment=%s", this.entity.getRedPacketApi(), this.entity.getSiteId(), this.getConfId(), this.entity.getServicetype(), StringUtil.urlEncode((String)this.entity.getAlbServer()), praiseType, this.entity.getUserId(), StringUtil.urlEncode((String)this.entity.getNickName()), toUserId, StringUtil.urlEncode((String)toUserName), StringUtil.urlEncode((String)comment));
        this.doGetRequest(address, new StringRes(){

            public void onRes(String result) {
                GenseeLog.d((String)MedalPraise.TAG, (String)("sendPraise result:" + result));
                int ret = -1;
                PraiseUserInfo userInfo = null;
                JSONObject object = AbsHandler.converToJson((String)result);
                if (object != null) {
                    ret = AbsHandler.getJsonInt((JSONObject)object, (String)"rc");
                    JSONObject response = AbsHandler.getJSONObj((JSONObject)object, (String)"response");
                    if (response != null) {
                        long userId = AbsHandler.getJsonLong((JSONObject)response, (String)"userid");
                        String username = AbsHandler.getJsonString((JSONObject)response, (String)"username");
                        int remain = AbsHandler.getJsonInt((JSONObject)response, (String)"remain");
                        int send = AbsHandler.getJsonInt((JSONObject)response, (String)"send");
                        int recv = AbsHandler.getJsonInt((JSONObject)response, (String)"recv");
                        userInfo = new PraiseUserInfo(userId, username, remain, send, recv);
                    }
                }
                if (MedalPraise.this.callback != null) {
                    MedalPraise.this.callback.onPraiseInfo(ret, praiseType, userInfo);
                }
            }

            public void onConnectError(int errorType, String errorInfo) {
                if (MedalPraise.this.callback != null) {
                    MedalPraise.this.callback.onPraiseInfo(errorType, praiseType, null);
                }
            }
        });
        return false;
    }

    @Override
    public boolean getPraiseTotal(final String praiseType) {
        if (this.entity == null) {
            GenseeLog.w((String)TAG, (String)"getPraiseTotal error, entity == null");
            return false;
        }
        String address = String.format(Locale.ENGLISH, "%s/getPraiseTotal?siteid=%d&confid=%s&servicetype=%s&alb=%s&praisetype=%s", this.entity.getRedPacketApi(), this.entity.getSiteId(), this.getConfId(), this.entity.getServicetype(), StringUtil.urlEncode((String)this.entity.getAlbServer()), praiseType);
        this.doGetRequest(address, new StringRes(){

            public void onRes(String result) {
                GenseeLog.d((String)MedalPraise.TAG, (String)("getPraiseTotal result:" + result));
                int ret = -1;
                int total = 0;
                JSONObject object = AbsHandler.converToJson((String)result);
                if (object != null) {
                    ret = AbsHandler.getJsonInt((JSONObject)object, (String)"rc");
                    JSONObject response = AbsHandler.getJSONObj((JSONObject)object, (String)"response");
                    if (response != null) {
                        total = AbsHandler.getJsonInt((JSONObject)response, (String)"total");
                    }
                }
                if (MedalPraise.this.callback != null) {
                    MedalPraise.this.callback.onPraiseTotal(ret, praiseType, total);
                }
            }

            public void onConnectError(int errorType, String errorInfo) {
                if (MedalPraise.this.callback != null) {
                    MedalPraise.this.callback.onPraiseTotal(errorType, praiseType, 0);
                }
            }
        });
        return false;
    }

    @Override
    public boolean getPraiseRecvList(final String praiseType, int maxUser) {
        if (this.entity == null) {
            GenseeLog.w((String)TAG, (String)"getPraiseRecvList error, entity == null");
            return false;
        }
        maxUser = maxUser <= 0 ? 50 : maxUser;
        String address = String.format(Locale.ENGLISH, "%s/getPraiseRecvList?siteid=%d&confid=%s&servicetype=%s&alb=%s&praisetype=%s&maxnbr=%d", this.entity.getRedPacketApi(), this.entity.getSiteId(), this.getConfId(), this.entity.getServicetype(), StringUtil.urlEncode((String)this.entity.getAlbServer()), praiseType, maxUser);
        this.doGetRequest(address, new StringRes(){

            public void onRes(String result) {
                GenseeLog.d((String)MedalPraise.TAG, (String)("getPraiseRecvList result:" + result));
                int ret = -1;
                PraiseInfo[] praises = null;
                JSONObject object = AbsHandler.converToJson((String)result);
                if (object != null) {
                    ret = AbsHandler.getJsonInt((JSONObject)object, (String)"rc");
                    JSONArray response = AbsHandler.getArray((JSONObject)object, (String)"response");
                    int size = response.length();
                    if (response != null && size > 0) {
                        praises = new PraiseInfo[size];
                        for (int i = 0; i < size; ++i) {
                            PraiseInfo praiseInfo;
                            JSONObject infoJO = AbsHandler.getJSONObj((JSONArray)response, (int)i);
                            if (null == infoJO) continue;
                            long userid = AbsHandler.getJsonLong((JSONObject)infoJO, (String)"userid");
                            String username = AbsHandler.getJsonString((JSONObject)infoJO, (String)"username");
                            int total = AbsHandler.getJsonInt((JSONObject)infoJO, (String)"total");
                            praises[i] = praiseInfo = new PraiseInfo(userid, username, total);
                        }
                    }
                }
                if (MedalPraise.this.callback != null) {
                    MedalPraise.this.callback.onPraiseRecvList(ret, praiseType, praises);
                }
            }

            public void onConnectError(int errorType, String errorInfo) {
                if (MedalPraise.this.callback != null) {
                    MedalPraise.this.callback.onPraiseRecvList(errorType, praiseType, null);
                }
            }
        });
        return false;
    }

    private String getConfId() {
        return GenseeConfig.getConfId((LoginResEntity)this.entity);
    }
}

