/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.vote;

import com.gensee.eventbu.EventbuTask;
import com.gensee.net.AbsHandler;
import com.gensee.vote.Question;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Vote
extends EventbuTask {
    public static final String MODULE_CARD = "card";
    public static final String MODULE_PAPER = "paper";
    public static final String MODULE_THIRD = "THIRD";
    public static final String ACTION_PUBLISH = "vote_publish";
    public static final String ACTION_ANSWER = "vote_answer";
    public static final String ACTION_DEADLINE = "vote_deadline";
    private String module = "card";
    private String voteId;
    private String action = "vote_answer";
    private String title;
    private List<Question> questions;
    private int timelimit;
    private String imgsrc;
    private String thumbnail;

    public Vote() {
        super("vote");
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getVoteId() {
        return this.voteId;
    }

    public void setVoteId(String voteId) {
        this.voteId = voteId;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<Question> getQuestions() {
        return this.questions;
    }

    public void setQuestions(List<Question> questions) {
        this.questions = questions;
    }

    public boolean appendQuestion(Question question) {
        if (this.questions == null) {
            this.questions = new ArrayList<Question>();
        }
        return this.questions.add(question);
    }

    public int getTimelimit() {
        return this.timelimit;
    }

    public void setTimelimit(int timelimit) {
        this.timelimit = timelimit;
    }

    public String getImgsrc() {
        return this.imgsrc;
    }

    public void setImgsrc(String imgsrc) {
        this.imgsrc = imgsrc;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    @Override
    public StringBuilder toJson(StringBuilder object) throws JSONException {
        super.toJson(object);
        this.putValue(object, "module", this.module);
        this.putValue(object, "voteId", this.voteId);
        this.putValue(object, "action", this.action);
        this.putValue(object, "title", this.title);
        this.putValue(object, "timelimit", String.valueOf(this.timelimit));
        this.putValue(object, "imgsrc", this.imgsrc);
        this.putValue(object, "thumbnail", this.thumbnail);
        this.putValue(object, "dst", this.getDst());
        if (this.questions != null && this.questions.size() > 0) {
            JSONArray questionArray = new JSONArray();
            for (Question question : this.questions) {
                questionArray.put((Object)question.toJSONObject(ACTION_PUBLISH.equals(this.action), ACTION_ANSWER.equals(this.action)));
            }
            this.putJSONObjValue(object, "questions", questionArray.toString());
        }
        return object;
    }

    public Vote fromJson(JSONObject voteJson) {
        if (voteJson != null) {
            this.setModule(AbsHandler.getJsonString((JSONObject)voteJson, (String)"module"));
            this.setVoteId(AbsHandler.getJsonString((JSONObject)voteJson, (String)"id"));
            this.setTitle(AbsHandler.getJsonString((JSONObject)voteJson, (String)"title"));
            this.setAlbUrl(AbsHandler.getJsonString((JSONObject)voteJson, (String)"albUrl"));
            this.setTimelimit(AbsHandler.getJsonInt((JSONObject)voteJson, (String)"timelimit"));
            this.setServiceType(AbsHandler.getJsonString((JSONObject)voteJson, (String)"serviceType"));
            JSONArray jsonQuestions = AbsHandler.getArray((JSONObject)voteJson, (String)"questions");
            int size = jsonQuestions == null ? 0 : jsonQuestions.length();
            for (int i = 0; i < size; ++i) {
                this.appendQuestion(new Question().formJson(AbsHandler.getJSONObj((JSONArray)jsonQuestions, (int)i)));
            }
        }
        return this;
    }
}

