/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.vote;

import com.gensee.net.AbsHandler;
import com.gensee.vote.Answer;
import com.gensee.vote.Option;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Question {
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_SINGLE = 2;
    public static final int TYPE_MUTI = 3;
    private String id;
    private String question;
    private int type = 1;
    private int added;
    private int score;
    private List<Answer> answers;
    private List<Option> options;
    private String imgsrc;
    private String thumbnail;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getAdded() {
        return this.added;
    }

    public void setAdded(int added) {
        this.added = added;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public List<Answer> getAnswers() {
        return this.answers;
    }

    public void setAnswers(List<Answer> answers) {
        this.answers = answers;
    }

    public boolean appendAnswer(Answer answer) {
        if (this.answers == null) {
            this.answers = new ArrayList<Answer>();
        }
        return this.answers.add(answer);
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public boolean appendOption(Option option) {
        if (this.options == null) {
            this.options = new ArrayList<Option>();
        }
        return this.options.add(option);
    }

    public String getImgsrc() {
        return this.imgsrc;
    }

    public void setImgsrc(String imgsrc) {
        this.imgsrc = imgsrc;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public JSONObject toJSONObject(boolean isPublish, boolean isAnswer) throws JSONException {
        JSONObject questionObj = new JSONObject().putOpt("id", (Object)this.id).putOpt("question", (Object)this.question).putOpt("type", (Object)this.type).putOpt("thumbnail", (Object)this.thumbnail).putOpt("imgsrc", (Object)this.imgsrc).putOpt("added", (Object)this.added).putOpt("score", (Object)this.score);
        if (this.type == 1 && isAnswer) {
            JSONArray answerArray = new JSONArray();
            if (this.answers != null && this.answers.size() > 0) {
                answerArray.put((Object)this.answers.get(0).toJSONObject());
            }
            questionObj.putOpt("answers", (Object)answerArray);
        }
        if (this.type != 1 && this.options != null && this.options.size() > 0) {
            JSONArray optionArray = new JSONArray();
            JSONArray itemArray = new JSONArray();
            for (int i = 0; i < this.options.size(); ++i) {
                Option option = this.options.get(i);
                optionArray.put((Object)option.toJSONObject());
                if (!option.isSelect()) continue;
                itemArray.put((Object)new JSONObject().putOpt("index", (Object)i).putOpt("id", (Object)option.getId()));
            }
            if (this.type != 1) {
                if (isPublish) {
                    questionObj.putOpt("options", (Object)optionArray);
                }
                if (isAnswer) {
                    questionObj.putOpt("items", (Object)itemArray);
                }
            }
        }
        return questionObj;
    }

    public Question formJson(JSONObject jsonObj) {
        this.setId(AbsHandler.getJsonString((JSONObject)jsonObj, (String)"id"));
        this.setQuestion(AbsHandler.getJsonString((JSONObject)jsonObj, (String)"question"));
        this.setType(AbsHandler.getJsonInt((JSONObject)jsonObj, (String)"type"));
        this.setAdded(AbsHandler.getJsonInt((JSONObject)jsonObj, (String)"added"));
        this.setThumbnail(AbsHandler.getJsonString((JSONObject)jsonObj, (String)"thumbnail"));
        this.setImgsrc(AbsHandler.getJsonString((JSONObject)jsonObj, (String)"imgsrc"));
        this.setScore(AbsHandler.getJsonInt((JSONObject)jsonObj, (String)"score"));
        JSONArray answersJson = AbsHandler.getArray((JSONObject)jsonObj, (String)"answers");
        int answerSize = answersJson == null ? 0 : answersJson.length();
        for (int i = 0; i < answerSize; ++i) {
            this.appendAnswer(new Answer().formJson(AbsHandler.getJSONObj((JSONArray)answersJson, (int)i)));
        }
        JSONArray optionsJson = AbsHandler.getArray((JSONObject)jsonObj, (String)"options");
        int optionSize = answersJson == null ? 0 : answersJson.length();
        for (int j = 0; j < optionSize; ++j) {
            this.appendOption(new Option().formJson(AbsHandler.getJSONObj((JSONArray)optionsJson, (int)j)));
        }
        return this;
    }
}

