/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.eventbu;

import com.gensee.common.GenseeConfig;
import com.gensee.entity.LoginResEntity;
import com.gensee.event.AnswerEvent;
import com.gensee.event.EventInfo;
import com.gensee.event.EventSubmitter;
import com.gensee.event.EventTask;
import com.gensee.event.SeatEvent;
import com.gensee.event.UserEvent;
import com.gensee.event.VoteEvent;
import com.gensee.eventbu.EventListener;
import com.gensee.eventbu.EventbuTask;
import com.gensee.net.AbsHandler;
import com.gensee.service.IBaseExtension;
import com.gensee.understands.UnderStandEvent;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.vote.Vote;
import org.json.JSONObject;

public class EventbuSDK
implements IBaseExtension {
    private LoginResEntity entity;
    private static final String TAG = "EventbuSDK";
    private EventSubmitter<EventbuTask> submitter = new EventSubmitter();
    private EventListener listener;
    private static final String JSON_TYPE_CONMAND = "command";

    public void setListener(EventListener listener) {
        this.listener = listener;
    }

    public void init(LoginResEntity entity) {
        this.entity = entity;
    }

    public void notify(String result) {
        if (StringUtil.isEmpty((String)result) || !result.startsWith("{")) {
            GenseeLog.w((String)TAG, (String)"notify other message!");
            return;
        }
        GenseeLog.d((String)TAG, (String)("notify listener = " + this.listener + " result:" + result));
        JSONObject object = AbsHandler.converToJson((String)result);
        String command = AbsHandler.getJsonString((JSONObject)object, (String)JSON_TYPE_CONMAND);
        JSONObject main = AbsHandler.getJSONObj((JSONObject)object, (String)"main");
        if ("vote_publish".equals(command)) {
            if (this.listener != null) {
                Vote vote = this.convertVote(main);
                vote.setAction("vote_publish");
                this.listener.onVotePublish(vote);
            }
        } else if ("vote_answer".equals(command)) {
            if (this.listener != null) {
                Vote vote = this.convertVote(main);
                vote.setAction("vote_answer");
                this.listener.onVotePublish(vote);
            }
        } else if ("vote_deadline".equals(command)) {
            if (this.listener != null) {
                Vote vote = this.convertVote(main);
                vote.setAction("vote_deadline");
                this.listener.onVotePublish(vote);
            }
        } else if ("understand".equals(command) && this.listener != null) {
            UnderStandEvent event = new UnderStandEvent("publish-understand");
            event.fromJson(main);
            this.listener.onUnderstands(event);
        }
    }

    private Vote convertVote(JSONObject object) {
        return new Vote().fromJson(object);
    }

    public boolean publishVote(Vote vote, EventSubmitter.OnSubmitListener l) {
        if (!this.isInit() || vote == null) {
            GenseeLog.w((String)TAG, (String)("publishVote vote is " + vote));
            return false;
        }
        vote.setAction("vote_publish");
        return this.sendData(vote, l);
    }

    public boolean answerVote(Vote vote, EventSubmitter.OnSubmitListener l) {
        if (!this.isInit() || vote == null) {
            GenseeLog.w((String)TAG, (String)("answerVote vote is " + vote));
            return false;
        }
        vote.setAction("vote_answer");
        return this.sendData(vote, l);
    }

    public boolean deadlineVote(Vote vote, EventSubmitter.OnSubmitListener l) {
        if (!this.isInit() || vote == null) {
            GenseeLog.w((String)TAG, (String)("deadlineVote vote is " + vote));
            return false;
        }
        vote.setAction("vote_deadline");
        return this.sendData(vote, l);
    }

    public UnderStandEvent publishUnderstands(EventSubmitter.OnSubmitListener l) {
        if (!this.isInit()) {
            return null;
        }
        UnderStandEvent event = new UnderStandEvent("publish-understand");
        boolean ret = this.sendData(event, l);
        return ret ? event : null;
    }

    public boolean answerUnderstand(String understandId, int comfirm, EventSubmitter.OnSubmitListener l) {
        if (StringUtil.isEmpty((String)understandId) || !this.isInit()) {
            GenseeLog.w((String)TAG, (String)("answerUnderstand understandId = " + understandId));
            return false;
        }
        UnderStandEvent event = new UnderStandEvent("confirm-understand");
        event.setUnderstandId(understandId);
        return this.sendData(event, l);
    }

    private boolean sendData(EventbuTask task, EventSubmitter.OnSubmitListener l) {
        this.initBuData(task);
        this.submitter.addEventTask(task);
        this.submitter.setListener(l);
        return this.submitter.synSubmit(this.getSubmitUrl());
    }

    public void submitLeaveEvent(int leaveReason) {
        if (!this.isNeedSubmit()) {
            return;
        }
        UserEvent event = new UserEvent();
        event.setAction(2);
        event.setLeaveReason(leaveReason);
        event.setNickName(this.entity.getNickName());
        this.initBaseData(event);
    }

    public void getClassReport(EventSubmitter.OnSubmitListener<EventInfo> listener) {
        EventInfo info = new EventInfo();
        this.initBaseData(info);
        info.addEventDataType(4);
        info.addEventDataType(16);
        info.addEventDataType(8);
        info.addEventDataType(32);
        info.addEventDataType(64);
        info.setFailTryTimes(0);
        EventSubmitter<EventInfo> submiter = new EventSubmitter<EventInfo>();
        submiter.addEventTask(info);
        submiter.setListener(listener);
        submiter.synSubmit(this.getReportUrl());
    }

    public void submitSeatEvent(int action) {
        if (!this.isNeedSubmit() || !this.isInit()) {
            return;
        }
        GenseeLog.i((String)TAG, (String)("start submitSeatEvent action=" + action));
        SeatEvent seatEvent = new SeatEvent(action);
        this.initBaseData(seatEvent);
        new EventSubmitter<SeatEvent>().addEventTask(seatEvent).synSubmit(this.getSubmitUrl());
    }

    public void submitCardEvent(String cardId) {
        if (!this.isNeedSubmit() || !this.isInit()) {
            return;
        }
        GenseeLog.i((String)TAG, (String)("start submitCardEvent card id=" + cardId));
        AnswerEvent answerEvent = new AnswerEvent();
        answerEvent.setAnswerId(cardId);
        this.initBaseData(answerEvent);
        new EventSubmitter<AnswerEvent>().addEventTask(answerEvent).synSubmit(this.getSubmitUrl());
    }

    public void submitVoteEvent(String paperId, int rightAnswerNum, int topicTotal) {
        if (!this.isNeedSubmit() || !this.isInit()) {
            GenseeLog.w((String)TAG, (String)"submitVoteEvent not need submit!");
            return;
        }
        GenseeLog.i((String)TAG, (String)("start submitVoteEvent paperId = [" + paperId + "], rightAnswerNum = [" + rightAnswerNum + "], topicTotal = [" + topicTotal + "]"));
        VoteEvent task = new VoteEvent();
        this.initBaseData(task);
        task.setPaperId(paperId);
        task.setAnswerNumber(rightAnswerNum);
        task.setTopicTotal(topicTotal);
        new EventSubmitter<VoteEvent>().addEventTask(task).synSubmit(this.getSubmitUrl());
    }

    public void submitHandUpEvent() {
        if (!this.isNeedSubmit() || !this.isInit()) {
            return;
        }
        GenseeLog.i((String)TAG, (String)"start submitHandUpEvent");
        new EventSubmitter<EventTask>().addEventTask(this.getBaseTask("handup")).synSubmit(this.getSubmitUrl());
    }

    public void submitJoinEvent() {
        if (!this.isNeedSubmit() || !this.isInit()) {
            return;
        }
    }

    private EventTask getBaseTask(String type) {
        EventTask eventTask = new EventTask(type);
        return this.initBaseData(eventTask);
    }

    private EventTask initBaseData(EventTask eventTask) {
        if (this.entity == null) {
            GenseeLog.e((String)TAG, (String)"initBaseData entity is null ,that not join room");
            return null;
        }
        eventTask.setConfId(GenseeConfig.getConfId((LoginResEntity)this.entity));
        eventTask.setSiteId(this.entity.getSiteId());
        eventTask.setUserId(this.entity.getUserId());
        eventTask.setOperaterUid(this.entity.getUserId());
        eventTask.setFailTryTimes(10);
        eventTask.setDelaySecond(10);
        return eventTask;
    }

    private EventbuTask initBuData(EventbuTask eventbuTask) {
        if (this.initBaseData(eventbuTask) == null) {
            return null;
        }
        eventbuTask.setAlbUrl(this.getAlbUrl());
        eventbuTask.setServiceType(this.entity.getServicetype());
        eventbuTask.setUserNickName(this.entity.getNickName());
        return eventbuTask;
    }

    private String getReportUrl() {
        return this.entity.getBhvUploadUrl() + "/client/event";
    }

    private String getSubmitUrl() {
        return this.entity.getBhvUploadUrl() + "/event";
    }

    private String getAlbUrl() {
        return this.entity.getAlbServer() + "/albcmd/broadmsg";
    }

    private boolean isNeedSubmit() {
        return true;
    }

    boolean isInit() {
        if (this.entity == null) {
            GenseeLog.w((String)TAG, (String)"isInit : not init or not join rooom");
            return false;
        }
        return true;
    }
}

