/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.event;

import com.gensee.event.EventTask;
import com.gensee.net.AbsHttpAction;
import com.gensee.net.StringRes;
import com.gensee.utils.GenseeLog;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

public class EventSubmitter<T extends EventTask>
extends AbsHttpAction {
    private static final String TAG = "EventSubmiter";
    private T task;
    private HashMap<String, String> header = new HashMap();
    private OnSubmitListener listener;

    public EventSubmitter() {
        super(null);
        this.header.put("Content-Type", "application/json");
    }

    public EventSubmitter addEventTask(T task) {
        this.task = task;
        return this;
    }

    public void setListener(OnSubmitListener listener) {
        this.listener = listener;
    }

    public boolean synSubmit(String url) {
        if (this.task == null || url == null) {
            this.notifyResult();
            return false;
        }
        String data = null;
        try {
            data = ((EventTask)this.task).getData();
            GenseeLog.d((String)TAG, (String)("synSubmit data " + data));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.notifyResult();
            return false;
        }
        this.synSubmit(url, data, ((EventTask)this.task).getFailTryTimes(), ((EventTask)this.task).getDelaySecond());
        return true;
    }

    private void synSubmit(final String url, final String data, final int failTryTimes, final int delaySeconds) {
        this.doPostRequest(url, data, this.header, new StringRes(){

            public void onRes(String s) {
                EventSubmitter.this.task.onResult(s);
                EventSubmitter.this.notifyResult();
                GenseeLog.d((String)EventSubmitter.TAG, (String)("synSubmit onRes " + s));
            }

            public void onConnectError(int i, String s) {
                GenseeLog.w((String)EventSubmitter.TAG, (String)("synSubmit onConnectError " + i + " - " + s + " failTryTimes = " + failTryTimes + " delaySeconds = " + delaySeconds + " type = " + EventSubmitter.this.task.getType()));
                if (failTryTimes == 0) {
                    EventSubmitter.this.notifyResult();
                } else {
                    final Timer timer = new Timer();
                    timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            EventSubmitter.this.synSubmit(url, data, failTryTimes - 1, delaySeconds);
                            timer.cancel();
                        }
                    }, delaySeconds * 1000);
                }
            }
        });
    }

    public void notifyResult() {
        if (this.listener != null) {
            this.listener.onSubmit(this.task);
        }
    }

    public static interface OnSubmitListener<T extends EventTask> {
        public void onSubmit(T var1);
    }
}

